<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Novo Ticket de Suporte - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="min-h-screen mb-10 text-white bg-black font-poppins">
    @include('layouts._partials.header')

    <div class="container relative z-10 px-3 pt-20 pb-8 mx-auto lg:px-4 lg:pt-24 lg:pb-12">
        <div class="mb-6 lg:mb-8">
            <div class="flex items-center mb-3 lg:mb-4">
                <a href="{{ route('support.index') }}" class="flex items-center mr-3 text-xs text-gray-400 lg:mr-4 hover:text-primary lg:text-base">
                    <i class="mr-1 lg:mr-2 fas fa-arrow-left"></i>
                    <span>Voltar</span>
                </a>
                <h1 class="text-xl font-bold text-white lg:text-3xl">Novo Ticket</h1>
            </div>
            <p class="mt-1 text-xs text-gray-400 lg:mt-2 lg:text-base">Preencha o formulário abaixo para reportar um problema ou solicitar ajuda.</p>
        </div>

        @if($errors->any())
            <div class="px-3 py-2 mb-4 text-red-300 border border-red-500 rounded lg:px-4 lg:py-3 lg:mb-6 bg-red-500/20">
                <ul class="pl-4 list-disc">
                    @foreach($errors->all() as $error)
                        <li class="text-xs lg:text-base">{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="p-4 shadow-lg lg:p-6 rounded-xl md:p-8 bg-zinc-900/50">
            <form action="{{ route('support.store') }}" method="POST">
                @csrf

                <div class="mb-4 lg:mb-6">
                    <label for="subject" class="block mb-1 text-xs text-gray-300 lg:mb-2 lg:text-base">Assunto</label>
                    <input type="text" id="subject" name="subject" value="{{ old('subject') }}"
                           class="w-full px-3 py-2 text-xs text-white border rounded-lg lg:px-4 lg:py-3 lg:text-base bg-zinc-800/50 border-zinc-700 focus:outline-none focus:border-primary"
                           required>
                </div>

                <div class="mb-4 lg:mb-6">
                    <label for="category" class="block mb-1 text-xs text-gray-300 lg:mb-2 lg:text-base">Categoria</label>
                    <select id="category" name="category"
                            class="w-full px-3 py-2 text-xs text-white border rounded-lg lg:px-4 lg:py-3 lg:text-base bg-zinc-800/50 border-zinc-700 focus:outline-none focus:border-primary"
                            required>
                        <option value="" disabled {{ old('category') ? '' : 'selected' }}>Selecione uma categoria</option>
                        @foreach($categories as $key => $category)
                            <option value="{{ $key }}" {{ old('category') == $key ? 'selected' : '' }}>{{ $category }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4 lg:mb-6">
                    <label for="message" class="block mb-1 text-xs text-gray-300 lg:mb-2 lg:text-base">Mensagem</label>
                    <textarea id="message" name="message" rows="6"
                              class="w-full px-3 py-2 text-xs text-white border rounded-lg lg:px-4 lg:py-3 lg:text-base bg-zinc-800/50 border-zinc-700 focus:outline-none focus:border-primary"
                              required>{{ old('message') }}</textarea>
                    <p class="mt-1 text-xs text-gray-400 lg:mt-2 lg:text-xs">Por favor, seja o mais detalhado possível sobre o problema encontrado.</p>
                </div>

                <div class="flex justify-end">
                    <a href="{{ route('support.index') }}" class="px-4 py-2 mr-2 text-xs text-white transition-colors rounded-full lg:px-6 lg:py-3 lg:mr-4 lg:text-xs bg-zinc-800 hover:bg-zinc-700">
                        Cancelar
                    </a>
                    <button type="submit" class="px-6 py-2 text-xs text-black transition-colors rounded-full lg:px-8 lg:py-3 lg:text-xs bg-primary hover:scale-105">
                        Enviar Ticket
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</body>
</html>
