<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Administrativo do Sorteio</title>
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- Estilos adicionais -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
    <style>
        body {
            padding-top: 50px;
            background-color: black;
            color: white;
        }

        .container {
            max-width: 100%;
        }

        .modal-content {
            color: white;
            background-color: black;
            border: 1px solid white;
        }

        th, td {
            color: white;
        }

        .custom-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5); /* Ajuste a opacidade conforme desejado aqui */
            z-index: 1040; /* Isso deve ser inferior ao z-index do modal para que o modal apareça na frente */
        }

        .confetti-canvas {
            z-index: 1060 !important;  /* Isso faz com que o confetti fique acima do modal */
            position: fixed;
        }

        .head-buttons {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <!-- Botão Sair no canto superior direito -->
    <div class="d-flex justify-content-end">
        <a href="{{ route('sorteioadmin.logout') }}" class="btn btn-danger mb-3" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Sair</a>
        <form id="logout-form" action="{{ route('sorteioadmin.logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    </div>

    <!-- Mensagens -->
    @if(session('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif
    <div class="head-buttons">
        <a href="{{ route('sorteioadmin.create') }}" class="btn btn-success mb-3">Criar novo sorteio</a>
        <a href="{{ route('reset.vencedores') }}" class="btn btn-danger" onclick="return confirm('Tem certeza que deseja resetar os vencedores? Esta ação não pode ser desfeita.');">
        Resetar Vencedores
        </a>
    </div>

    <!-- Lista de Sorteios -->
    <h2>Sorteios Cadastrados</h2>
    <div class="table-responsive-xxl">
        <table class="table table-bordered mb-5">
            <thead>
                <tr>
                    <th>Título</th>
                    <th>Descrição</th>
                    <th>Data do Sorteio</th>
                    <th>Imagem</th>
                    <th>Ação</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sorteios as $sorteio)
                <tr>
                    <td>{{ $sorteio->titulo }}</td>
                    <td>{{ $sorteio->descricao }}</td>
                    <td>{{ \Carbon\Carbon::parse($sorteio->data_sorteio)->format('d/m/Y H:i') }}</td>
                    <td>
                        @if($sorteio->imagem)
                            <img src="{{ asset('storage/' . $sorteio->imagem) }}" alt="{{ $sorteio->titulo }}" width="100">
                        @else
                            Sem imagem
                        @endif
                    </td>
                    <td>
                    <a href="{{ route('sorteioadmin.edit', $sorteio->id) }}" class="btn btn-warning mb-2">Editar</a>
                    <form action="{{ route('sorteioadmin.destroy', $sorteio->id) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Tem certeza que deseja excluir este sorteio?')">Excluir</button>
                    </form>
                    <a href="#" data-id="{{ $sorteio->id }}" class="btn btn-primary mt-2 realizarSorteio">Realizar Sorteio</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <form action="{{ route('sorteioadmin.dashboard') }}" method="GET" class="mb-3">
        <div class="input-group">
            <input type="text" class="form-control" name="search" placeholder="Pesquisar usuário por nome ou e-mail" value="{{ old('search') }}">
            <div class="input-group-append">
                <button type="submit" class="btn btn-primary">Pesquisar</button>
            </div>
        </div>
    </form>

    <!-- Título e botão de sorteio -->
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1>Usuários Cadastrados</h1>
    </div>

    <!-- Lista de usuários -->
    <div class="table-responsive-xxl">
        <table class="table table-bordered mb-5">
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Email</th>
                    <th>Chave Pix</th>
                    <th>Whatsapp</th>
                    <th>Sorteado(a)</th>
                </tr>
            </thead>
            <tbody>
                @foreach($usuarios as $usuario)
                    <tr>
                        <td>{{ $usuario->nome }}</td>
                        <td>{{ $usuario->email }}</td>
                        <td>{{ $usuario->chave_pix }}</td>
                        <td>{{ $usuario->whatsapp }}</td>
                        <td>
                        @if(!$usuario->sorteado)
                            <i class="fas fa-times text-danger"></i>
                        @else
                            <i class="fas fa-check text-success"></i>
                        @endif

                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>


<div class="modal fade" id="winnerModal" tabindex="-1" aria-labelledby="winnerModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="winnerModalLabel">Parabéns ao Vencedor!</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <p>Nome: <span id="winnerName"></span></p>
        <p>Email: <span id="winnerEmail"></span></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>

<script>
    $(document).on('hidden.bs.modal', '#winnerModal', function () {
    $('.custom-backdrop').remove();
});
</script>
<script>
    function showWinnerModal(name, email) {
    document.getElementById('winnerName').textContent = name;
    document.getElementById('winnerEmail').textContent = obfuscateEmail(email);

    // Adicione o fundo personalizado ao corpo
    let backdrop = document.createElement('div');
    backdrop.className = 'custom-backdrop';
    document.body.appendChild(backdrop);

    $('#winnerModal').modal('show');
}

</script>

<script>
    function obfuscateEmail(email) {
    var emailParts = email.split("@");
    var namePart = emailParts[0];
    var domainPart = emailParts[1];

    // Se o e-mail tiver menos de 3 caracteres antes do @, mantenha-o intacto.
    if (namePart.length <= 3) {
        return email;
    }

    // Ofusca o e-mail, mostrando apenas os primeiros 3 caracteres e o domínio.
    return namePart.substr(0, 3) + "..." + "@" + domainPart;
}
</script>

@if(isset($winner))
<script>
    showWinnerModal('{{ $winner->nome }}', obfuscateEmail('{{ $winner->email }}'));
</script>
@endif

<script>
    $(document).ready(function() {
    console.log("Document is ready!");

    $('.realizarSorteio').on('click', function(e) {
        console.log("Link was clicked!");

        e.preventDefault();

        var sorteioId = $(this).data('id');
        console.log("Sorteio ID:", sorteioId);

        $.ajax({
            url: `/public/sorteioadmin/realizar-sorteio/${sorteioId}`,
            method: 'GET',
            success: function(response) {
                console.log("AJAX success:", response);

                if (response.success) {
                    showWinnerModal(response.winner.nome, response.winner.email);
                    var canvas = document.getElementById('myConfettiCanvas');
                    confetti({
                        particleCount: 250,
                        spread: 90,
                        zIndex:2000,
                        startVelocity: 30,
                        origin: { y: 0.4 }
                    });
                } else {
                    alert(response.message);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error("AJAX error:", textStatus, errorThrown);
                alert('Erro ao realizar o sorteio. Por favor, tente novamente.');
            }
        });
    });
});
</script>
<canvas id="myConfettiCanvas" style="position:fixed; top:0; left:0; width:100%; height:100%; z-index:2000; pointer-events:none;"></canvas>
</body>
</html>
