<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro para o Sorteio</title>
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
    <style>
        .fundo{
            background-color: black;
            color: white;
        }
        .next {
            margin: 10px;
            padding: 36px 0 32px 0;
        }

        ol {
            font-size: 14px;
        }

        .guide {
            font-size: 19px;
        }

        .mt-5 {

            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        .info {
            background-color: yellow;
            border-radius: 25px;
            padding: 10px;
            color: black;
            outline: none;
            border: none;
            font-weight: 700;
        }

        .info:hover, .info:focus {
            border: none;
            outline: none;
        }

        .info2 {
            background-color: #3394fd;
            border-radius: 25px;
            padding: 10px;
            color: white;
            outline: none;
            border: none;
            font-weight: 700;
        }

        .info2:hover, .info2:focus {
            border: none;
            outline: none;
        }


        .botoes {
            display: flex;
            margin-bottom: 20px;
            gap: 5px;
            width: -webkit-fill-available;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            border: 2px solid #393939;
            padding: 15px;
            border-radius: 20px;
        }

        .footer {
            display: flex;
            justify-content: center;
            padding: 15px;
            margin: 100px 0 0 0px;
        }

        .image-container {
            text-align: center;
            margin: 21px 0;
        }

        .image-container img {
            max-width: 100%;
            height: auto;
        }

        .title-sorteio {
            background: linear-gradient(45deg, #f06, #9f6);
            color: transparent; /* torna a cor do texto transparente para que o gradiente possa ser visível */
            -webkit-background-clip: text;
            background-clip: text;
            font-weight: bold;
            display: inline-block; /* Isso é necessário porque o background-clip não funcionará em elementos de bloco no Firefox */
        }

        .descricao {
            text-align: center;
        }

        .titlesub {
            position: relative;
            display: flex;
            justify-content: center;
            flex-direction: column;
            align-items: center;
            padding: 15px;
            background: black;
            border-radius: 20px;
            margin: 4px 0 34px 0;
        }

        .titlesub::before {
            content: '';
            position: absolute;
            top: -2px;
            right: -2px;
            bottom: -2px;
            left: -2px;
            background: linear-gradient(45deg, #f06, #9f6);
            border-radius: inherit;
            z-index: -1; /* coloca atrás do elemento original */
        }

        .mb-4 {
            display: flex;
            flex-direction: column;
            justify-content: center;
            border: 2px solid #393939;
            border-radius: 20px;
            padding: 15px;
        }

        a:hover {
            text-decoration: none;
        }

        .instagram-btn {
            display: flex;
            align-items: center;
            padding: 10px 20px;
            margin-top: 15px;
            justify-content: center;
            border: none;
            width: 80%;
            border-radius: 25px;
            cursor: pointer;
            background: linear-gradient(137deg, #405DE6, #5851DB, #833AB4, #C13584, #E1306C, #FD1D1D, #F56040, #F77737, #FCAF45, #FFDC80);
            color: white;
            text-decoration: none;
            transition: transform 0.2s;
            &:hover {
                transform: scale(1.05);
                text-decoration: none;
                color: white;
            }
        }

        .instagram-btn .fab {
            margin-right: 10px;
        }

        .alert-succes {
            color: #155724;
            font-weight: 500;
            background-color: #62e080;
            border-color: #009823;
        }

        .alert-dange {
            color: #6b2626;
            font-weight: 500;
            background-color: #e06262;
            border-color: #980000;
        }

        .form-control {
            border-radius: 1.25rem!important;
        }

    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/css/intlTelInput.css">

    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
</head>
<body class="fundo" >
    <div class="container mt-5">
        <div class="image-container">
            <img src="https://i.imgur.com/hR3lIJh.png" alt="Sorteios" class="img-fluid">
        </div>

        <div class="titlesub">
             <h3 class="title-sorteio">Sorteio Premium</h3>
             <span class="descricao">Exclusivo para usuários com uma assinatura ativa no {{$settings->app_name}}.</span>
        </div>
        <!-- Instruções para o Sorteio -->
        <div class="mb-4">
            <h3 class="guide">Instruções para participar do sorteio:</h3>
            <ol>
                <li>Primeiro tenha uma assinatura ativa no {{$settings->app_name}}, portanto use o seu email cadastrado no app.</li>
                <li>Informe a chave pix onde você gostaria de receber o prêmio e seu Whatsapp para entrarmos em contato.</li>
                <li>Depois que fizer o cadastro apenas aguarde, se você ganhar irá receber o prêmio e entrará na lista de ganhadores do sorteio.</li>
                <li>Vá até nosso post do instagram e comente marcando no minimo 3 amigos. Se você vencer o sorteio será necessário comprovar com print.</li>
                <a href="https://www.instagram.com/p/CxiZCLfLSq3/?igshid=MzRlODBiNWFlZA==" target="_blank" class="instagram-btn">
                    <i class="fab fa-instagram"></i> Ver Post no Instagram
                </a>
            </ol>
        </div>

        <div class="botoes">

            <form action="{{ route('show.winners') }}" method="get">
                <button class="info">Ver Ganhadores</button>
            </form>

            <form action="{{ route('next.sorteios') }}" method="get">
                <button class="info2">Próximos Sorteios</button>
            </form>
        </div>


        <!-- Formulário de Cadastro -->
        <div class="container mt-4">
            <h2>Cadastro</h2>

            @if(session('success'))
                <div class="alert alert-succes">
                    {{ session('success') }}
                </div>
                @endif

            @if($errors->has('email'))
                <div class="alert alert-dange">
                    {{ $errors->first('email') }}
                </div>
            @endif

            <form action="{{ route('usuario.store') }}" method="POST" id="cadastro">
                @csrf

                <div class="form-group">
                    <label for="email" class="text-white">Email:</label>
                    <input type="email" name="email" class="form-control" placeholder="Digite seu e-mail cadastrado no app {{$settings->app_name}}" required>
                    @error('email')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="nome" class="text-white">Nome:</label>
                    <input type="text" name="nome" class="form-control" placeholder="Digite seu nome" required>
                    @error('nome')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="chave_pix" class="text-white">Chave PIX:</label>
                    <input type="text" name="chave_pix" class="form-control" placeholder="Digite sua chave PIX" required>
                    @error('chave_pix')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="whatsapp" class="text-white">WhatsApp para receber o Gift-Card:</label>
                    <input type="tel" id="whatsapp" name="whatsapp" class="form-control" placeholder="Ex: 21 9 9999-9999">
                    @error('whatsapp')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <button type="submit" class="btn btn-success">Cadastrar</button>
            </form>
        </div>
    </div>

    <script>
        document.querySelector('#cadastro').addEventListener('submit', function() {
    sessionStorage.setItem('scrollPosition', window.scrollY);
});
    </script>

    <script>
        window.addEventListener('DOMContentLoaded', (event) => {
    const scrollPosition = sessionStorage.getItem('scrollPosition');
    if (scrollPosition) {
        window.scrollTo(0, parseInt(scrollPosition));
        sessionStorage.removeItem('scrollPosition');
    }
});
    </script>

    <script>
        $(document).ready(function() {
            $("#whatsapp").intlTelInput({
                preferredCountries: ["br"], // pode adicionar os códigos dos países que deseja como preferidos
                separateDialCode: true,
                utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/utils.js"
            });
        });
    </script>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.13/js/intlTelInput-jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

<footer class="footer">
    <span>{{$settings->app_name}} 2023 - Todos os direitos reservados</span>
</footer>
</html>
