@if ($searchResults->isEmpty())
    <div class="py-8 text-center">
        <h3 class="text-xl text-zinc-400">Nenhum resultado encontrado.</h3>
    </div>
@else
    <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 animate-fade-in">
        @foreach ($searchResults as $result)
            <a href="{{ match($result->type) {
                'serie' => route('serie.detail', ['id' => $result->id]),
                'anime' => route('anime.detail', ['id' => $result->id]),
                default => route('filme.detail', ['id' => $result->id])
            } }}" class="block group">
                <div class="relative overflow-hidden rounded-lg image-wrapper">
                    <img src="{{ $result->poster_path }}"
                         alt="{{ $result->name }}"
                         class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                         loading="lazy">
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                </div>
            </a>
        @endforeach
    </div>
@endif
