<!-- resources/views/proximos_sorteios.blade.php -->

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Próximos Sorteios</title>
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
    
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/lottie-web/5.7.8/lottie.min.js" crossorigin="anonymous"></script>
    <style>
        body {
            background-color: #000;
            color: #fff;
        }
        img {
            max-width: 100%;
        }

        a {
            text-decoration: none;
        }

        a:hover {
            text-decoration: none;
        }

        .voltar {
            background-color: #444;
            color: #fff;
            border-radius: 20px;
            padding: 15px;
            outline: none;
            list-style: none;
        }

        .mt-5 {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

    </style>
</head>
<body>

    <div class="container mt-5">
        <div id="lottie-container" style="width: 100%; height: 300px; margin-bottom: 20px;"></div>
        <a href="{{ url()->previous() }}" class="voltar">Voltar</a>
        <h1 class="text-center mb-5">Próximos Sorteios</h1>
        
        @if(isset($sorteios) && !$sorteios->isEmpty())
            <div class="row">
                @foreach($sorteios as $sorteio)
                    <div class="col-12 mb-4"> <!-- Aqui a mudança, de col-md-4 para col-12 -->
                        <div class="card bg-dark text-white">
                            <img src="{{ asset('storage/' . $sorteio->imagem) }}" class="card-img-top" alt="{{ $sorteio->titulo }}">
                            <div class="card-body">
                                <h5 class="card-title">{{ $sorteio->titulo }}</h5>
                                <p class="card-text">Data: {{ \Carbon\Carbon::parse($sorteio->data_sorteio)->format('d/m/Y H:i') }} (Horário de Brasília)</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <p class="text-center">Desculpe, a data do próximo sorteio ainda não foi definida.</p>
        @endif
    </div>

    <script>
        // Carregar animação Lottie
        let animation = lottie.loadAnimation({
            container: document.getElementById('lottie-container'),
            renderer: 'svg',
            loop: true,
            autoplay: true,
            path: 'https://lottie.host/4893ed9d-e834-4403-8877-0413aee884a9/j1nb8jjeVD.json'  // Substitua 'URL_DO_LOTTIE' pela URL que você fornecerá
        });
    </script>

    <!-- Optional: Bootstrap JS and JQuery -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
