<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processar Link</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&family=Roboto:wght@400;500;900&family=Work+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>

        * {
            font-family: 'Poppins', sans-serif;
            font-family: 'Roboto', sans-serif;
            font-family: 'Work Sans', sans-serif;
        }

        body{
            color: white;
            font-size: 17px;
            font-family: 'Poppins', sans-serif;
            background-color: black;
        }

        input {
            border-radius: 15px;
            border: none;
            height: 30px;
            width: 50%;
            outline-color: #36ff03;
            font-family: 'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif;
        }

        form {
            display: grid;
            gap: 15px;
            width: 100%;
            margin: 25px auto;
            justify-items: center;
        }

        section {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            top: 100px;
            justify-content: center;
        }

        .btn-green {
            border-radius: 15px;
            border: none;
            background-color: #36ff03;
            cursor: pointer;
            width: 50%;
            font-family: 'Roboto', sans-serif;
            height: 32px;
            font-weight: 800;
            transition: .3s;
        }

        .btn-primary-blue {
            border-radius: 15px;
            border: none;
            background-color: #037bff;
            cursor: pointer;
            width: 50%;
            font-family: 'Roboto', sans-serif;
            height: 32px;
            font-weight: 800;
            transition: .3s;
        }

        .btn-green:hover {
            background-color: #35ae16;
        }

        .alert {
            color: #36ff03;
            margin: 10px 0px 12px 0px;
            padding: 8px;
        }

        .alerte {
            color: #FC0134;
            margin: 10px 0px 12px 0px;
            padding: 8px;
        }

        .processar, .indexar {
            width: 100%;
        }


    </style>
</head>
<body>
    <section>
        <!-- Exibir mensagens de status -->
        @if(session('status') == 'success')
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('message') }}
        </div>
        @endif

        @if(session('status') == 'error')
        <div class="alerte alert-success">
            <i class="fas fa-check-circle"></i>
            {{ session('message') }}
        </div>
        @endif

        <div class="indexar" >
            <form action="{{ route('reindex-movies') }}">
                @csrf
                <label for="link">1 - Primeiro Indexe os filmes novamente</label>
                <button type="submit" class="btn-primary-blue">Reindexar Filmes</button>
            </form>
        </div>

        <div class="processar">
            <form method="POST" action="{{ route('processar-link') }}">
                @csrf
                <label for="link">2 - Agora cole o link do Arquivo TXT:</label>
                <input type="text" name="link" required>
                <button class="btn-green" type="submit">Processar</button>
            </form>
        </div>
    </section>
</body>
</html>
