@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Pagamento Concluído</div>

                <div class="card-body">
                    <div class="alert alert-success" role="alert">
                        <h4 class="alert-heading">Pagamento realizado com sucesso!</h4>
                        <p>Seu pagamento foi processado e confirmado.</p>
                    </div>

                    <div class="transaction-details">
                        <h5 class="mb-3">Detalhes da Transação</h5>
                        <p><strong>ID da Transação:</strong> {{ $payment->transaction_id }}</p>
                        <p><strong>Valor:</strong> R$ {{ number_format($payment->amount, 2, ',', '.') }}</p>
                        <p><strong>Data:</strong> {{ $payment->created_at->format('d/m/Y H:i') }}</p>
                        <p><strong>Status:</strong> {{ ucfirst($payment->status) }}</p>
                    </div>

                    <div class="mt-4">
                        <a href="{{ route('home') }}" class="btn btn-primary">Voltar ao Início</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
