@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Pagamento com Cartão de Crédito</div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div id="payment-alert" class="alert alert-danger" style="display: none;" role="alert">
                    </div>

                    <form method="POST" action="{{ route('payment.credit-card.process') }}" id="payment-form">
                        @csrf

                        <div class="mb-3 row">
                            <label for="amount" class="col-md-4 col-form-label text-md-end">Valor (R$)</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control @error('amount') is-invalid @enderror"
                                    name="amount" value="{{ old('amount') }}" required>
                                @error('amount')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label for="description" class="col-md-4 col-form-label text-md-end">Descrição</label>
                            <div class="col-md-6">
                                <input type="text" class="form-control @error('description') is-invalid @enderror"
                                    name="description" value="{{ old('description') ?? 'Assinatura Ultraflix' }}" required>
                                @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label for="installments" class="col-md-4 col-form-label text-md-end">Parcelas</label>
                            <div class="col-md-6">
                                <select name="installments" class="form-control @error('installments') is-invalid @enderror" required>
                                    @for ($i = 1; $i <= 12; $i++)
                                        <option value="{{ $i }}">{{ $i }}x</option>
                                    @endfor
                                </select>
                                @error('installments')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="mt-4 mb-4 card">
                            <div class="card-header">Dados do Cartão</div>
                            <div class="card-body">
                                <div class="mb-3 row">
                                    <label for="card_number" class="col-md-4 col-form-label text-md-end">Número do Cartão</label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control @error('card_number') is-invalid @enderror"
                                            name="card_number" value="{{ old('card_number') }}" required>
                                        @error('card_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="card_holder_name" class="col-md-4 col-form-label text-md-end">Nome no Cartão</label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control @error('card_holder_name') is-invalid @enderror"
                                            name="card_holder_name" value="{{ old('card_holder_name') }}" required>
                                        @error('card_holder_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="card_expiration_date" class="col-md-4 col-form-label text-md-end">Data de Validade</label>
                                    <div class="col-md-3">
                                        <input type="text" placeholder="MM/AA" class="form-control @error('card_expiration_date') is-invalid @enderror"
                                            name="card_expiration_date" value="{{ old('card_expiration_date') }}" required>
                                        @error('card_expiration_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <label for="card_cvv" class="col-md-1 col-form-label text-md-end">CVV</label>
                                    <div class="col-md-2">
                                        <input type="text" class="form-control @error('card_cvv') is-invalid @enderror"
                                            name="card_cvv" value="{{ old('card_cvv') }}" required>
                                        @error('card_cvv')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-4 mb-4 card">
                            <div class="card-header">Dados do Cliente</div>
                            <div class="card-body">
                                <div class="mb-3 row">
                                    <label for="customer_name" class="col-md-4 col-form-label text-md-end">Nome Completo</label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control @error('customer_name') is-invalid @enderror"
                                            name="customer_name" value="{{ old('customer_name') ?? auth()->user()->name ?? '' }}" required>
                                        @error('customer_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="customer_email" class="col-md-4 col-form-label text-md-end">Email</label>
                                    <div class="col-md-6">
                                        <input type="email" class="form-control @error('customer_email') is-invalid @enderror"
                                            name="customer_email" value="{{ old('customer_email') ?? auth()->user()->email ?? '' }}" required>
                                        @error('customer_email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="customer_document" class="col-md-4 col-form-label text-md-end">CPF</label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control @error('customer_document') is-invalid @enderror"
                                            name="customer_document" value="{{ old('customer_document') }}" required>
                                        @error('customer_document')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="customer_phone" class="col-md-4 col-form-label text-md-end">Telefone</label>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control @error('customer_phone') is-invalid @enderror"
                                            name="customer_phone" value="{{ old('customer_phone') }}" required>
                                        @error('customer_phone')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-0 row">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary" id="submit-button">
                                    Efetuar Pagamento
                                </button>
                                <div class="spinner-border text-primary mt-2" role="status" id="loading-spinner" style="display: none;">
                                    <span class="visually-hidden">Processando...</span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('payment-form');
        const submitButton = document.getElementById('submit-button');
        const loadingSpinner = document.getElementById('loading-spinner');
        const paymentAlert = document.getElementById('payment-alert');

        // Máscara para CPF
        const cpfInput = document.querySelector('input[name="customer_document"]');
        cpfInput?.addEventListener('input', function() {
            let value = this.value.replace(/\D/g, '');
            if (value.length > 11) value = value.slice(0, 11);

            if (value.length > 9) {
                value = value.replace(/(\d{3})(\d{3})(\d{3})/, '$1.$2.$3-');
            } else if (value.length > 6) {
                value = value.replace(/(\d{3})(\d{3})/, '$1.$2.');
            } else if (value.length > 3) {
                value = value.replace(/(\d{3})/, '$1.');
            }

            this.value = value;
        });

        // Máscara para cartão de crédito
        const cardInput = document.querySelector('input[name="card_number"]');
        cardInput?.addEventListener('input', function() {
            let value = this.value.replace(/\D/g, '');
            if (value.length > 16) value = value.slice(0, 16);

            // Formatação 0000 0000 0000 0000
            if (value.length > 0) {
                value = value.match(/.{1,4}/g).join(' ');
            }

            this.value = value;
        });

        // Máscara para data de expiração
        const expInput = document.querySelector('input[name="card_expiration_date"]');
        expInput?.addEventListener('input', function() {
            let value = this.value.replace(/\D/g, '');
            if (value.length > 4) value = value.slice(0, 4);

            if (value.length > 2) {
                value = value.replace(/(\d{2})(\d)/, '$1/$2');
            }

            this.value = value;
        });

        // Máscara para telefone
        const phoneInput = document.querySelector('input[name="customer_phone"]');
        phoneInput?.addEventListener('input', function() {
            let value = this.value.replace(/\D/g, '');
            if (value.length > 11) value = value.slice(0, 11);

            if (value.length > 6) {
                value = value.replace(/(\d{2})(\d{4,5})(\d{4})/, '($1) $2-$3');
            } else if (value.length > 2) {
                value = value.replace(/(\d{2})(\d)/, '($1) $2');
            }

            this.value = value;
        });

        // Processamento AJAX do formulário
        form.addEventListener('submit', function(e) {
            e.preventDefault();

            // Mostrar spinner e desabilitar botão
            submitButton.disabled = true;
            loadingSpinner.style.display = 'inline-block';
            paymentAlert.style.display = 'none';

            // Enviar formulário via AJAX
            fetch(form.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json'
                },
                body: JSON.stringify(Object.fromEntries(new FormData(form)))
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Redirecionar para página de sucesso
                    if (data.redirect) {
                        window.location.href = data.redirect;
                    } else {
                        // Mostrar mensagem de sucesso
                        paymentAlert.classList.remove('alert-danger');
                        paymentAlert.classList.add('alert-success');
                        paymentAlert.textContent = 'Pagamento realizado com sucesso!';
                        paymentAlert.style.display = 'block';
                        form.reset();
                    }
                } else {
                    // Mostrar mensagem de erro
                    paymentAlert.textContent = data.message || 'Ocorreu um erro ao processar o pagamento.';
                    paymentAlert.style.display = 'block';
                }
            })
            .catch(error => {
                paymentAlert.textContent = 'Erro na comunicação com o servidor: ' + error.message;
                paymentAlert.style.display = 'block';
            })
            .finally(() => {
                // Esconder spinner e reabilitar botão
                submitButton.disabled = false;
                loadingSpinner.style.display = 'none';
            });
        });
    });
</script>
@endsection
