<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Pagamento PIX - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="min-h-screen font-sans text-white bg-black"
      style="background-image: linear-gradient(to right, rgba(0, 0, 0, 86%), transparent), linear-gradient(to left, rgba(0, 0, 0, 86%), transparent), linear-gradient(to top, rgb(0, 0, 0, 0%), transparent), url('/public/assets/images/background.jpg'); background-attachment: fixed; background-size: cover; background-position: center center;">

    <div class="container max-w-2xl px-4 py-10 mx-auto">
        <div class="p-6 border shadow-xl bg-zinc-900/70 backdrop-blur-lg border-zinc-800/50 rounded-xl">
            <!-- Header -->
            <div class="mb-8 text-center">
                <h1 class="mb-2 text-2xl font-bold">Pagamento PIX</h1>
                <p class="text-zinc-300">Plano: {{ $plano }} - R$ {{ number_format($valor, 2, ',', '.') }}</p>
                <!-- Identificador do gateway -->
                <div hidden class="mt-2 text-xs text-zinc-500">
                    Gateway: {{ $gateway ?? 'suitpay' }}
                </div>
            </div>

            <!-- QR Code Container -->
            <div class="p-6 mb-6 text-center bg-white rounded-xl">
                <img src="data:image/png;base64,{{ $qrcode }}" alt="QR Code PIX"
                     class="w-64 h-64 mx-auto mb-3">
                <p class="text-sm text-gray-500">Escaneie o QR Code com o app do seu banco</p>
            </div>

            <!-- Copy PIX Container -->
            <div class="relative mb-6">
                <input type="text" id="pix-code" value="{{ $qrcode_text }}" readonly
                       class="w-full p-4 pl-4 pr-12 text-white border rounded-lg bg-zinc-800 border-zinc-700" />
                <button id="copy-button" class="absolute text-xl transform -translate-y-1/2 right-3 top-1/2 text-primary">
                    <i class="fas fa-copy"></i>
                </button>
            </div>

            <!-- Instructions -->
            <div class="p-4 mb-6 border-l-4 rounded-r-lg bg-zinc-800/50 border-primary">
                <h3 class="mb-3 text-lg font-medium text-primary">Como pagar com PIX:</h3>
                <ol class="ml-5 space-y-2 list-decimal text-zinc-300">
                    <li>Abra o app do seu banco</li>
                    <li>Escolha a opção de pagamento por PIX</li>
                    <li>Escaneie o QR Code ou cole o código copiado</li>
                    <li>Confirme as informações e finalize o pagamento</li>
                </ol>
            </div>

            <!-- Status containers -->
            <div id="status-waiting" class="p-4 mb-6 text-center border-l-4 rounded-r-lg bg-amber-900/20 border-amber-500">
                <div class="w-8 h-8 mx-auto mb-3 border-4 rounded-full border-zinc-600 border-t-amber-400 animate-spin"></div>
                <p class="mb-2 font-medium text-amber-400">Aguardando confirmação do pagamento...</p>
                <div class="text-sm text-zinc-400">
                    Tempo restante: <span id="countdown" class="font-medium">30:00</span>
                </div>
            </div>

            <div id="status-success" class="hidden p-4 mb-6 text-center border-l-4 rounded-r-lg bg-green-900/20 border-primary">
                <i class="mb-3 text-3xl fas fa-check-circle text-primary"></i>
                <p class="mb-4 font-medium text-primary">Pagamento confirmado com sucesso!</p>
                <a href="{{ route('inicio') }}" class="inline-block w-full px-6 py-3 font-bold text-black transition-colors rounded-full bg-primary hover:scale-105">
                    Ir para o início
                </a>
            </div>

            <div id="status-error" class="hidden p-4 mb-6 text-center border-l-4 border-red-500 rounded-r-lg bg-red-900/20">
                <i class="mb-3 text-3xl text-red-500 fas fa-exclamation-circle"></i>
                <p class="mb-4 font-medium text-red-400">Tempo expirado ou erro no pagamento.</p>
                <a href="{{ route('choose.plan') }}" class="inline-block w-full px-6 py-3 font-bold text-white transition-colors bg-transparent border-2 rounded-full hover:bg-zinc-800 border-zinc-600 hover:border-primary">
                    Tentar novamente
                </a>
            </div>

            <!-- Transaction info -->
            <div class="text-sm text-center text-zinc-500">
                <p class="mb-1 overflow-hidden">Referência: {{ $reference }}</p>
                <p>Após o pagamento, aguarde alguns segundos para a confirmação automática.</p>
            </div>

            <!-- Botão de verificação manual sempre visível -->
            <div class="mt-4 text-center">
                <button id="manual-check-btn" class="px-4 py-2 text-white rounded bg-zinc-700 hover:bg-zinc-600">
                    Verificar pagamento manualmente
                </button>
                <p class="mt-2 text-xs text-zinc-400">
                    Clique no botão acima se já realizou o pagamento e deseja verificar o status.
                </p>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Funcionalidade para copiar o código PIX
            document.getElementById('copy-button').addEventListener('click', function() {
                const pixCode = document.getElementById('pix-code');
                pixCode.select();
                pixCode.setSelectionRange(0, 99999);
                document.execCommand('copy');

                // Feedback visual
                this.innerHTML = '<i class="fas fa-check"></i>';
                setTimeout(() => {
                    this.innerHTML = '<i class="fas fa-copy"></i>';
                }, 2000);
            });

            // Iniciar contador regressivo
            const countdownEl = document.getElementById('countdown');
            let timeLeft = 30 * 60; // 30 minutos em segundos

            function updateCountdown() {
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                countdownEl.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

                if (timeLeft <= 0) {
                    clearInterval(countdownInterval);
                    document.getElementById('status-waiting').classList.add('hidden');
                    document.getElementById('status-error').classList.remove('hidden');
                }
                timeLeft--;
            }

            updateCountdown();
            const countdownInterval = setInterval(updateCountdown, 1000);

            // Função para lidar com o sucesso do pagamento
            function handlePaymentSuccess(data) {
                // Esconder status de espera
                document.getElementById('status-waiting').classList.add('hidden');
                // Mostrar status de sucesso
                document.getElementById('status-success').classList.remove('hidden');

                // Marcar pagamento como confirmado no localStorage
                localStorage.setItem('payment_success_' + transactionId, 'true');

                // Se houver URL de redirecionamento, redirecionar após um breve delay
                if (data.redirect) {
                    setTimeout(function() {
                        window.location.href = data.redirect;
                    }, 1500);
                }
            }

            // Sistema melhorado de verificação de status com suporte a verificação manual
            const transactionId = '{{ $reference }}';
            const gateway = '{{ $gateway ?? "suitpay" }}';
            console.log("Gateway ativo:", gateway); // Log para debug
            let checkCount = 0;
            let failedAttempts = 0;
            const maxChecks = 120; // 20 minutos (verificando a cada 10 segundos)

            // Função para verificar o status do pagamento
            function checkPaymentStatus(forceCheck = false) {
                if (checkCount >= maxChecks && !forceCheck) {
                    clearInterval(statusInterval);
                    console.log('Tempo limite de verificação atingido');
                    return;
                }

                console.log(`Verificando status - tentativa ${checkCount + 1}${forceCheck ? ' (forçada)' : ''}`);

                // Determinar a rota correta para verificar o status com base no gateway
                const statusRoute = gateway === 'paggue'
                    ? '{{ route("paggue.status") }}'
                    : '{{ route("suitpay.status") }}';
                console.log("Rota de status:", statusRoute); // Log para debug

                fetch(statusRoute, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({
                        transaction_id: transactionId,
                        gateway: gateway,
                        timestamp: Date.now(),
                        force_check: forceCheck // Flag para verificação manual
                    })
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Resposta da verificação:', data);

                    if (data.status === 'success') {
                        // Pagamento confirmado - mostrar sucesso e redirecionar
                        handlePaymentSuccess(data);
                    } else if (forceCheck) {
                        // Se foi uma verificação forçada, mostrar feedback
                        const checkButton = document.getElementById('manual-check-btn');
                        checkButton.innerHTML = 'Pagamento ainda pendente';
                        checkButton.classList.remove('bg-zinc-700');
                        checkButton.classList.add('bg-amber-600');

                        // Restaurar o botão após 2 segundos
                        setTimeout(() => {
                            checkButton.disabled = false;
                            checkButton.innerHTML = 'Verificar pagamento manualmente';
                            checkButton.classList.remove('bg-amber-600');
                            checkButton.classList.add('bg-zinc-700');
                        }, 2000);
                    }

                    if (!forceCheck) checkCount++;
                })
                .catch(error => {
                    console.error('Erro ao verificar status:', error);
                    failedAttempts++;

                    if (!forceCheck) checkCount++;
                });
            }

            // Iniciar verificação
            statusInterval = setInterval(checkPaymentStatus, 10000); // A cada 10 segundos

            // Primeira verificação imediata
            checkPaymentStatus();

            // Botão de verificação manual
            const manualButton = document.getElementById('manual-check-btn');
            if (manualButton) {
                manualButton.addEventListener('click', function() {
                    this.disabled = true;
                    this.innerHTML = '<span class="mr-2">Verificando...</span><div class="w-4 h-4 border-2 border-white rounded-full border-t-transparent animate-spin"></div>';

                    // Forçar verificação imediata com a flag force_check
                    checkPaymentStatus(true);
                });
            }

            // Verificar localStorage ao carregar a página
            if (localStorage.getItem('payment_success_' + transactionId) === 'true') {
                window.location.href = '{{ route("pagamento.sucesso") }}';
            }
        });
    </script>

    <!-- Instruções melhoradas para o usuário -->
    <div class="p-4 mt-6 text-center border-l-4 rounded-r-lg bg-zinc-800/50 border-amber-400">
        <p class="text-sm text-amber-100">
            <i class="mr-1 fas fa-info-circle"></i>
            Após realizar o pagamento, aguarde alguns instantes para a confirmação automática.
            Se o pagamento não for confirmado em breve, clique em "Verificar pagamento manualmente".
        </p>
    </div>
</body>
</html>
