<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Notificações - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    @include('layouts._partials.header')

    <div class="container px-4 pt-24 pb-12 mx-auto">
        <h1 class="mb-8 text-3xl font-bold">Notificações</h1>

        <!-- Adicionados Recentemente -->
        <section class="mb-12">
            <h2 class="flex items-center mb-6 text-2xl font-semibold">
                <span class="mr-2 text-primary"><i class="fas fa-plus-circle"></i></span>
                Adicionados Recentemente
            </h2>

            <!-- Filmes recentes -->
            @if(count($recentMovies) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Filmes</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($recentMovies as $movie)
                    <a href="{{ $movie->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $movie->poster_path }}" alt="{{ $movie->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black bg-green-500 rounded-full">NOVO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $movie->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($movie->created_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Séries recentes -->
            @if(count($recentSeries) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Séries</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($recentSeries as $serie)
                    <a href="{{ $serie->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $serie->poster_path }}" alt="{{ $serie->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black bg-green-500 rounded-full">NOVO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $serie->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($serie->created_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Animes recentes -->
            @if(count($recentAnimes) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Animes</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($recentAnimes as $anime)
                    <a href="{{ $anime->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $anime->poster_path }}" alt="{{ $anime->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black bg-green-500 rounded-full">NOVO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $anime->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($anime->created_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif
        </section>

        <!-- Atualizados Recentemente -->
        <section class="mb-12">
            <h2 class="flex items-center mb-6 text-2xl font-semibold">
                <span class="mr-2 text-amber-500"><i class="fas fa-sync-alt"></i></span>
                Atualizados Recentemente
            </h2>

            <!-- Filmes atualizados -->
            @if(count($updatedMovies) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Filmes</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($updatedMovies as $movie)
                    <a href="{{ $movie->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $movie->poster_path }}" alt="{{ $movie->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black rounded-full bg-amber-500">ATUALIZADO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $movie->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($movie->updated_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Séries atualizadas -->
            @if(count($updatedSeries) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Séries</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($updatedSeries as $serie)
                    <a href="{{ $serie->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $serie->poster_path }}" alt="{{ $serie->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black rounded-full bg-amber-500">ATUALIZADO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $serie->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($serie->updated_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Animes atualizados -->
            @if(count($updatedAnimes) > 0)
            <div class="mb-8">
                <h3 class="mb-4 text-xl font-medium text-zinc-300">Animes</h3>
                <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5">
                    @foreach($updatedAnimes as $anime)
                    <a href="{{ $anime->route }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg bg-zinc-900">
                            <img src="{{ $anime->poster_path }}" alt="{{ $anime->display_name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

                            <div class="absolute top-2 right-2">
                                <span class="px-2 py-1 text-xs font-bold text-black rounded-full bg-amber-500">ATUALIZADO</span>
                            </div>

                            <div class="absolute bottom-0 left-0 right-0 p-3">
                                <h4 class="font-medium truncate">{{ $anime->display_name }}</h4>
                                <p class="text-xs text-gray-400">{{ Carbon\Carbon::parse($anime->updated_at)->format('d/m/Y') }}</p>
                            </div>
                        </div>
                    </a>
                    @endforeach
                </div>
            </div>
            @endif
        </section>

        <!-- Mensagem quando não há conteúdo -->
        @if(count($recentMovies) == 0 && count($recentSeries) == 0 && count($recentAnimes) == 0 &&
            count($updatedMovies) == 0 && count($updatedSeries) == 0 && count($updatedAnimes) == 0)
        <div class="flex flex-col items-center justify-center py-12 text-center">
            <div class="mb-4 text-5xl text-zinc-600">
                <i class="fas fa-bell-slash"></i>
            </div>
            <h3 class="mb-2 text-2xl font-medium text-zinc-400">Nenhuma notificação encontrada</h3>
            <p class="text-zinc-600">Não há conteúdo novo ou atualizado recentemente.</p>
        </div>
        @endif
    </div>

    <!-- Script para animação nos cards -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const notificationItems = document.querySelectorAll('.grid > a');

            // Aplicar animação de fade-in para os itens
            notificationItems.forEach((item, index) => {
                item.style.opacity = '0';
                item.style.transform = 'translateY(20px)';
                item.style.transition = 'opacity 0.5s ease, transform 0.5s ease';

                setTimeout(() => {
                    item.style.opacity = '1';
                    item.style.transform = 'translateY(0)';
                }, 100 + (index * 50)); // Efeito cascata, cada item aparece após o outro
            });
        });
    </script>

</body>
</html>
