<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>

    <style>
    body {
        background-color: black;
        color: white;
        font-family: Arial, sans-serif;
    }

    .container {
        max-width: 800px;
        margin: 0 auto;
        padding: 20px;
        background-color: rgba(0, 0, 0, 0.7); /* Fundo preto translúcido */
        border-radius: 10px;
    }

    h1 {
        text-align: center;
        margin-bottom: 20px;
    }

    ol {
        list-style-position: inside;
    }

    .pagination {
        display: flex;
        justify-content: center; /* Centraliza os links de paginação */
        list-style-type: none;
        padding: 0;
    }

    .pagination li {
        background-color: white;
        color: black;
        margin: 5px;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 14px; /* Tamanho da fonte reduzido */
    }

    .pagination li a {
        color: black;
        text-decoration: none;
    }

    .pagination li.active a,
    .pagination li:hover a {
        color: white;
    }

    .pagination li.active,
    .pagination li:hover {
        background-color: #007bff;
    }

    .pagination li.disabled {
        color: grey;
        background-color: transparent;
    }

    .pagination li.disabled a {
        color: grey;
        pointer-events: none;
    }
</style>

</head>
<body>
    <div class="container">
        <h1>Filmes Marcados como Inativos</h1>
        <ol>
            @foreach($movies as $movie)
                <li>{{ $movie->title }}</li>
            @endforeach
        </ol>
        {{ $movies->links() }} <!-- Links de paginação -->
    </div>
</body>
</html>