<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Casa Comigo?</title>
  <link rel="icon" href="https://cdn-icons-png.flaticon.com/512/833/833472.png" type="image/x-icon">

  <script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.7.8/lottie.min.js"></script>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
  <style>
    /* Estilos do modal */

    body {
      font-family: 'Poppins', 'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
      font-weight: 700
    }
    .container {
        text-align: center;
        width: 100%;
        height: 100%;
        
    }
    .question {
      font-size: 24px;
      margin-bottom: 20px;
    }
    .options {
      display: flex;
      justify-content: center;
    }
    .option {
        font-size: 20px;
    padding: 10px 20px;
    margin: 0 10px;
    width: 50px;
    border: 4px solid #ff0bec;
    cursor: pointer;
    border-radius: 34px;
    }
    .option.no {
      position: relative;
    }
    .option.no:hover {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
    }
    .hidden-image {
      display: none;
      margin-top: 20px;
      max-width: 100%;
      height: auto;
    }
    /* Estilos adicionais para tornar a imagem responsiva */
    @media (max-width: 768px) {
      .hidden-image {
        max-width: 90%;
      }
    }

    .modal {
     display: none;
    position: fixed;
    z-index: 1;
    left: 0;
    top: -89px;
    width: 100%;
    height: 115%;
    overflow: auto;
    background-color: rgb(255 0 198 / 80%);
    }
    .modal-content {
      display: block;
      margin: 15% auto;
      max-width: 72%;
      max-height: 90%;
    }
    .modal-image {
      width: 100%;
      height: 100%;
      object-fit: cover;
      border-radius: 25px;
    }

    .option.no:hover {
        position: absolute;
        top: 79%;
        left: 72%;
        transform: translate(-18%, -65%);
        animation: zigzag 0.9s infinite;
    }

    @keyframes zigzag {
      0% { transform: translate(-50%, -50%) rotate(0); }
      25% { transform: translate(-55%, -55%) rotate(75deg); }
      50% { transform: translate(-50%, -50%) rotate(0); }
      75% { transform: translate(-45%, -45%) rotate(-5deg); }
      100% { transform: translate(-50%, -50%) rotate(0); }
    }

    #lottie-container {
        width: 200px;
        height: 200px;
        margin-bottom: -15px;
        margin-left: 35%;
        margin-top: 23%;
        }
  </style>
</head>
<body>
    <div class="container">

        <div id="lottie-container"></div>
        <div class="question">Casa comigo?</div>
        <div class="options">
          <div class="option">Sim</div>
          <div class="option no rotating">Não</div>
        </div>
      </div>

  <!-- Modal (popup) -->
  <div id="myModal" class="modal">
    <span class="close">&times;</span>
    <div class="modal-content">
      <img class="modal-image" src="/public/assets/images/mozin.jpg" alt="Imagem de comemoração">
    </div>
  </div>

  <script>
    const options = document.querySelectorAll('.option');
    const modal = document.getElementById('myModal');

    options.forEach(option => {
      option.addEventListener('click', () => {
        if (!option.classList.contains('no')) {
          modal.style.display = 'block';
        }
      });
    });

    // Fechar o modal ao clicar no botão de fechar (x)
    const closeButton = document.querySelector('.close');
    closeButton.addEventListener('click', () => {
      modal.style.display = 'none';
    });

    // Fechar o modal quando clicar fora da imagem
    window.addEventListener('click', (event) => {
      if (event.target === modal) {
        modal.style.display = 'none';
      }
    });
  </script>

<script>
    // Carregue a animação Lottie
    var animation = bodymovin.loadAnimation({
        container: document.getElementById('lottie-container'),
        renderer: 'svg',
        loop: true,
        autoplay: true,
        path: 'https://lottie.host/fbec41c4-cc8c-4c65-849d-fd75df3205e9/IYF5BhFK03.json' // Substitua pelo caminho correto para o arquivo JSON da animação
    });
</script>
</body>
</html>
