<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Limite de Dispositivos - {{$settings->app_name}}Conecta Plus</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
    <style>
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-fade-in {
            animation: fadeIn 0.5s ease-out forwards;
        }
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        .animate-bounce-slow {
            animation: bounce 2s infinite;
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    @include('layouts._partials.header')

    <div class="container px-4 py-16 mx-auto">
        <div class="max-w-2xl p-8 mx-auto text-center rounded-lg animate-fade-in bg-gradient-to-br from-zinc-800 to-zinc-900">
            <div class="mb-6 animate-bounce-slow">
                <div class="flex items-center justify-center w-16 h-16 mx-auto mb-3 rounded-full bg-red-500/20">
                    <i class="text-3xl text-red-500 fa-solid fa-user-slash"></i>
                </div>
                <h1 class="mb-4 text-2xl font-bold">Limite de Dispositivos Atingido</h1>
            </div>

            <div class="p-4 mb-8 text-left rounded-lg bg-zinc-700/50">
                <p class="mb-4">
                    Você atingiu o limite máximo de dispositivos ativos permitidos pelo seu plano atual.
                    Para continuar assistindo neste dispositivo, escolha uma das opções abaixo:
                </p>

                <ul class="mb-6 space-y-4">
                    <li class="flex">
                        <div class="flex items-center justify-center flex-shrink-0 w-6 h-6 mr-3 rounded-full bg-primary/20">
                            <span class="text-xs font-semibold text-primary">1</span>
                        </div>
                        <div>
                            <p class="font-medium">Remova um dispositivo existente</p>
                            <p class="text-sm text-zinc-400">Libere espaço removendo um dispositivo que não está mais em uso.</p>
                        </div>
                    </li>
                    <li class="flex">
                        <div class="flex items-center justify-center flex-shrink-0 w-6 h-6 mr-3 rounded-full bg-primary/20">
                            <span class="text-xs font-semibold text-primary">2</span>
                        </div>
                        <div>
                            <p class="font-medium">Faça um upgrade do seu plano</p>
                            <p class="text-sm text-zinc-400">Obtenha acesso a mais dispositivos simultâneos com um plano superior.</p>
                        </div>
                    </li>
                </ul>
            </div>

            <!-- Informações adicionais -->
            <div class="p-4 mb-8 text-left rounded-lg bg-zinc-700/30">
                <h3 class="mb-2 font-semibold text-primary">Dispositivo atual:</h3>
                <div class="flex items-center mb-4">
                    @php
                        $agent = new \Jenssegers\Agent\Agent();
                        $deviceIcon = $agent->isPhone() ? 'fa-mobile-screen' : ($agent->isTablet() ? 'fa-tablet-screen-button' : 'fa-desktop');
                        $deviceType = $agent->isPhone() ? 'Celular' : ($agent->isTablet() ? 'Tablet' : 'Computador');
                        $deviceInfo = $agent->platform() . ' - ' . $agent->browser();
                    @endphp
                    <div class="flex items-center justify-center w-8 h-8 mr-3 rounded-full bg-zinc-600">
                        <i class="fas {{ $deviceIcon }}"></i>
                    </div>
                    <div>
                        <p class="font-medium">{{ $deviceType }}</p>
                        <p class="text-xs text-zinc-400">{{ $deviceInfo }}</p>
                    </div>
                </div>
                <p class="text-xs text-zinc-400">
                    <i class="mr-1 fas fa-info-circle"></i>
                    Este dispositivo ainda não foi adicionado à sua conta devido ao limite atingido.
                </p>
            </div>

            <div class="flex flex-col gap-4 sm:flex-row sm:justify-center">
                <a href="{{ route('devices.index') }}"
                   class="flex items-center justify-center gap-2 px-6 py-3 font-medium text-white transition-colors rounded-md bg-primary hover:scale-105">
                    <i class="fas fa-user-cog"></i>
                    Gerenciar Dispositivos
                </a>
                <a href="{{ route('choose.plan') }}"
                   class="flex items-center justify-center gap-2 px-6 py-3 font-medium transition-colors border rounded-md text-primary border-primary hover:bg-primary/10">
                    <i class="fas fa-arrow-up"></i>
                    Mudar de Plano
                </a>
            </div>
        </div>

        <!-- Perguntas frequentes -->
        <div class="max-w-2xl py-6 mx-auto mt-8">
            <h3 class="mb-4 text-xl font-semibold text-center">Perguntas Frequentes</h3>

            <div class="space-y-4">
                <div class="p-4 rounded-lg bg-zinc-800">
                    <h4 class="mb-2 font-medium text-primary">O que conta como um dispositivo?</h4>
                    <p class="text-sm text-zinc-300">
                        Cada aparelho (celular, tablet, smart TV ou computador) em que você acessa sua conta é contado como um dispositivo diferente.
                    </p>
                </div>

                <div class="p-4 rounded-lg bg-zinc-800">
                    <h4 class="mb-2 font-medium text-primary">Por quanto tempo um dispositivo permanece registrado?</h4>
                    <p class="text-sm text-zinc-300">
                        Um dispositivo é considerado ativo por até 30 dias após o último uso. Após esse período, ele é removido automaticamente.
                    </p>
                </div>

                <div class="p-4 rounded-lg bg-zinc-800">
                    <h4 class="mb-2 font-medium text-primary">Como posso aumentar meu limite de dispositivos?</h4>
                    <p class="text-sm text-zinc-300">
                        Você pode fazer upgrade para um plano superior que ofereça mais dispositivos simultâneos através da seção "Mudar de Plano".
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>
</body>
</html>
