<head>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css">
<style>
    .top10filmes {
        text-align: center;
        margin: 20px auto;
    }

    .slick-carousel {
        width: 80%;
        margin: 0 auto;
    }

    .filme {
        padding: 20px;
        border: 1px solid #ccc;
        background-color: #f5f5f5;
        text-align: center;
    }

    .filme img {
        max-width: 100%;
        height: auto;
    }

    h3 {
        margin-top: 10px;
        font-size: 18px;
    }

    p {
        margin-top: 5px;
        font-size: 14px;
    }
</style>
</head>
<section class="top10filmes">
    <div class="slick-carousel">
        @foreach ($top10 as $filme)
            <div class="filme">
                <img src="{{ $filme->poster_path }}" alt="{{ $filme->name }}">
                <h3>{{ $filme->name }}</h3>
                <p>{{ $filme->overview }}</p>
                <p>Gênero: {{ $filme->genre_name }}</p>
                <p>Data de lançamento: {{ $filme->release_date }}</p>
                <p>Avaliação: {{ $filme->vote_average }}</p>
                <p>Visualizações: {{ $filme->views }}</p>
            </div>
        @endforeach
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
<script>
    $(document).ready(function(){
        $('.slick-carousel').slick({
            slidesToShow: 3,
            slidesToScroll: 1,
            autoplay: true,
            autoplaySpeed: 5000,
            responsive: [
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 2
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1
                    }
                }
            ]
        });
    });
</script>