<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&display=swap" rel="stylesheet">
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('css/all.css') }}">

    <!-- Preload de recursos críticos -->
    <link rel="preload" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/css/splide.min.css"></noscript>

    <!-- Preload de scripts críticos -->
    <link rel="preload" href="https://code.jquery.com/jquery-3.6.0.min.js" as="script">
    <link rel="preload" href="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js" as="script">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/@splidejs/splide@4.1.4/dist/js/splide.min.js"></script>
    <script src="{{ asset('js/all.js') }}" defer></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
    <script src="{{ asset('js/custom-player.js') }}" defer></script>

    <meta name="base-url" content="{{ url('/') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <script>
        // Define a URL base para scripts JavaScript
        window.appUrl = "{{ url('/') }}";

        // Sistema de navegação otimizada para transições mais suaves
        window.addEventListener('DOMContentLoaded', function() {
            // Configurar links para mostrar indicador de carregamento
            document.querySelectorAll('a').forEach(function(link) {
                if (!link.getAttribute('href') ||
                    link.getAttribute('href').startsWith('#') ||
                    link.getAttribute('href').startsWith('javascript:') ||
                    link.getAttribute('href').includes('logout') ||
                    link.getAttribute('target') === '_blank' ||
                    link.getAttribute('download') ||
                    link.classList.contains('no-loader')) {
                    return;
                }

                link.addEventListener('click', function(e) {
                    if (e.ctrlKey || e.metaKey || e.shiftKey) return; // Não interfere quando teclas modificadoras estão pressionadas

                    // Mostrar indicador de carregamento
                    document.getElementById('page-transition-loader').classList.remove('hidden');
                });
            });
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function loadScript(src, callback) {
                const script = document.createElement('script');
                script.src = src;
                script.onload = callback || function(){};
                document.body.appendChild(script);
            }

            loadScript("{{ asset('js/random-content-player.js') }}");

            // Definir configurações globais para carrosséis
            window.carouselConfig = {
                type: 'slide',
                rewind: true,
                arrows: true,
                pagination: false,
                autoplay: false,
                gap: '0rem',
                padding: { right: '0rem' },
                breakpoints: {
                    520: { perPage: 3, padding: { right: '0rem' } },
                    640: { perPage: 3, padding: { right: '0rem' } },
                    768: { perPage: 4, padding: { right: '0rem' } },
                    1024: { perPage: 5, padding: { right: '0rem' } },
                    1280: { perPage: 6, padding: { right: '0rem' } },
                    1536: { perPage: 7, padding: { right: '0rem' } },
                    1920: { perPage: 7, padding: { right: '0rem' } }
                }
            };

            window.wideCarouselConfig = {
                ...window.carouselConfig,
                breakpoints: {
                    520: { perPage: 2, padding: { right: '0rem' } },
                    640: { perPage: 2, padding: { right: '0rem' } },
                    768: { perPage: 2, padding: { right: '0rem' } },
                    1024: { perPage: 3, padding: { right: '0rem' } },
                    1280: { perPage: 4, padding: { right: '0rem' } },
                    1536: { perPage: 5, padding: { right: '0rem' } },
                    1920: { perPage: 6, padding: { right: '0rem' } }
                }
            };

            window.top10CarouselConfig = {
                ...window.carouselConfig,
                breakpoints: {
                    520: { perPage: 2, padding: { right: '0rem' } },
                    640: { perPage: 2, padding: { right: '0rem' } },
                    768: { perPage: 3, padding: { right: '0rem' } },
                    1024: { perPage: 4, padding: { right: '0rem' } },
                    1280: { perPage: 6, padding: { right: '0rem' } },
                    1536: { perPage: 7, padding: { right: '0rem' } },
                    1920: { perPage: 7, padding: { right: '0rem' } }
                }
            };
        });
    </script>

    <style>
        /* Estilos para o badge de notificação */
        .notification-badge {
            transition: opacity 0.3s ease, transform 0.3s ease;
        }

        .notification-badge.opacity-100 {
            transform: scale(1);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% {
                transform: scale(0.95);
                box-shadow: 0 0 0 0 rgba(255, 0, 0, 0.7);
            }

            70% {
                transform: scale(1);
                box-shadow: 0 0 0 6px rgba(255, 0, 0, 0);
            }

            100% {
                transform: scale(0.95);
                box-shadow: 0 0 0 0 rgba(255, 0, 0, 0);
            }
        }

        /* Estilos melhorados para o dropdown do perfil */
        .profile-dropdown {
            display: none;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s;
            background-color: rgba(39, 39, 42, 0.6); /* zinc-800 com 60% de opacidade */
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .profile-container:hover .profile-dropdown,
        .profile-dropdown:hover {
            display: block;
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
            transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0s;
        }

        /* Ajustes para o conteúdo do dropdown com fundo transparente */
        .profile-dropdown .border-zinc-700 {
            border-color: rgba(255, 255, 255, 0.1);
        }

        .profile-dropdown .hover\:bg-zinc-700:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        /* Comportamento do header ao scrollar */
        .header-transparent {
            background-color: transparent;
            transition: background-color 0.3s ease, backdrop-filter 0.3s ease;
        }

        .header-blur {
            background-color: rgba(24, 24, 27, 0.85); /* zinc-900 com opacidade */
            backdrop-filter: blur(8px);
            transition: background-color 0.3s ease, backdrop-filter 0.3s ease;
        }

        /* Efeito glass para o menu */
        .nav-item {
            position: relative;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
            overflow: hidden;
        }

        .nav-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 40%;
            background: linear-gradient(to bottom, rgba(255,255,255,0.15), rgba(255,255,255,0));
            border-radius: 0.5rem 0.5rem 0 0;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .nav-item.active {
            background: rgba(255, 255, 255, 0.1);
        }

        .nav-item.active::before {
            opacity: 1;
        }

        .nav-item:hover {
            background: rgba(255, 255, 255, 0.95);
            color: #000;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .nav-item:hover i,
        .nav-item:hover span {
            color: #000;
        }

        /* Indicador de carregamento de página */
        .page-transition-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            z-index: 9999;
            background: linear-gradient(to right, transparent, #2BF14A, transparent);
            opacity: 0;
            transition: opacity 0.2s ease;
            animation: loading-bar 1.5s infinite ease-in-out;
        }

        .page-transition-loader.active {
            opacity: 1;
        }

        @keyframes loading-bar {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        /* Ajuste para melhorar a percepção de velocidade */
        body {
            opacity: 0;
            animation: fadeIn 0.3s ease forwards;
        }

        @keyframes fadeIn {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body>
    <!-- Indicador de carregamento de página -->
    <div id="page-transition-loader" class="hidden page-transition-loader"></div>

    @php
        // Adicionar timestamp para prevenir cache prejudicial
        $cacheBuster = '?v=' . time();
    @endphp

    <!-- Menu Desktop (Topo) -->
    <header id="desktop-header" class="fixed top-0 left-0 z-50 hidden w-full py-2 header-transparent lg:block">
        <div class="container flex items-center justify-between px-4 mx-auto">
            <!-- Logo -->
            <a href="{{ route('inicio') }}" class="flex items-center">
                <img class="object-cover w-auto h-14" src="{{ route('minilogo') }}" alt="Logo">
            </a>

            <!-- Navigation Links -->
            <nav class="flex items-center space-x-2 text-white">
                <a href="{{ route('inicio') }}" class="flex items-center text-sm transition-colors nav-item {{ request()->routeIs('inicio') ? 'active' : '' }}">
                    <i class="mr-1 text-base fa-regular fa-house-blank"></i>
                    <span>Início</span>
                </a>
                <a href="{{ route('filmes.index') }}" class="flex items-center text-sm transition-colors nav-item {{ request()->routeIs('filmes.index') ? 'active' : '' }}">
                    <i class="mr-1 text-base fa-regular fa-clapperboard-play"></i>
                    <span>Filmes</span>
                </a>
                <a href="{{ route('series.index') }}" class="flex items-center text-sm transition-colors nav-item {{ request()->routeIs('series.index') ? 'active' : '' }}">
                    <i class="mr-1 text-base fa-solid fa-tv-retro"></i>
                    <span>Séries</span>
                </a>
                <a href="{{ route('animes.index') }}" class="flex items-center text-sm transition-colors nav-item {{ request()->routeIs('animes.index') ? 'active' : '' }}">
                    <i class="mr-1 text-base fa-regular fa-fan"></i>
                    <span>Desenhos</span>
                </a>
                <a href="{{ route('livetv.index') }}" class="flex items-center text-sm transition-colors nav-item">
                    <i class="mr-1 text-base fa-solid fa-signal-stream"></i>
                    <span>Canais</span>
                </a>
                <a href="{{ route('search') }}" class="flex items-center text-sm transition-colors nav-item {{ request()->routeIs('search') ? 'active' : '' }}">
                    <i class="mr-1 text-base fa-regular fa-magnifying-glass"></i>
                    <span>Pesquisar</span>
                </a>
            </nav>

            <!-- Profile e Dropdown -->
            <div class="flex items-center space-x-4">
                <div class="relative" hidden>
                    <span id="desktop-notification-badge" class="absolute z-50 flex items-center justify-center w-5 h-5 text-xs font-bold text-white transform translate-x-2 -translate-y-2 bg-red-500 rounded-full top-3 opacity-3 right-1 notification-badge">0</span>
                    <a href="{{ route('notifications') }}" class="transition-colors hover:text-primary">
                        <i class="text-xl fa-regular fa-bell"></i>
                    </a>
                </div>

                @auth
                <!-- Container do perfil com dropdown para usuários logados -->
                <div class="relative profile-container">
                    <!-- Avatar do perfil -->
                    <div class="w-10 h-10 overflow-hidden transition-all border-2 border-transparent rounded-full cursor-pointer hover:border-primary">
                        <img class="object-cover w-full h-full"
                             src="{{ session('selected_profile') && session('selected_profile')->avatar ? asset(session('selected_profile')->avatar) : asset('/avatars/avatar_default.png') }}"
                             alt="{{ session('selected_profile') ? session('selected_profile')->name : 'Perfil' }}">
                    </div>

                    <!-- Dropdown menu com atraso no fechamento -->
                    <div class="absolute right-0 z-50 w-56 overflow-hidden rounded-md shadow-lg profile-dropdown">
                        <!-- Perfil atual -->
                        <div class="flex items-center p-4 space-x-3 border-b border-zinc-700">
                            <div class="w-10 h-10 overflow-hidden rounded-full">
                                <img class="object-cover w-full h-full"
                                     src="{{ session('selected_profile') && session('selected_profile')->avatar ? asset(session('selected_profile')->avatar) : asset('/avatars/avatar_default.png') }}"
                                     alt="{{ session('selected_profile') ? session('selected_profile')->name : 'Perfil' }}">
                            </div>
                            <div>
                                <p class="font-medium text-white">{{ session('selected_profile') ? session('selected_profile')->name : 'Perfil' }}</p>
                                <p class="text-xs text-zinc-400">{{ auth()->user()->email ?? 'email@exemplo.com' }}</p>
                            </div>
                        </div>

                        <!-- Lista de perfis disponíveis - mostra apenas se o usuário tiver múltiplos perfis -->
                        @if(auth()->check() && count(auth()->user()->profiles) > 1)
                            <div class="py-2 border-b border-zinc-700">
                                <p class="px-4 py-1 text-xs font-medium text-zinc-500">Trocar de perfil</p>
                                @foreach(auth()->user()->profiles as $profile)
                                    @if(!session('selected_profile') || $profile->id != session('selected_profile')->id)
                                        <a href="{{ url('/select-profile/'.$profile->id) }}" class="flex items-center px-4 py-2 space-x-3 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                            <div class="w-6 h-6 overflow-hidden rounded-full">
                                                <img class="object-cover w-full h-full" src="{{ $profile->avatar ? asset($profile->avatar) : asset('/avatars/avatar_default.png') }}" alt="{{ $profile->name }}">
                                            </div>
                                            <span>{{ $profile->name }}</span>
                                        </a>
                                    @endif
                                @endforeach
                                <a href="{{ route('choose-profile') }}" class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                    <i class="w-5 mr-2 text-center fa-solid fa-user-gear"></i>
                                    <span>Gerenciar perfis</span>
                                </a>
                            </div>
                        @endif

                        <div class="py-1">
                            <a href="{{ route('user.profile') }}" class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fa-regular fa-user-vneck"></i>
                                <span>Minha conta</span>
                            </a>
                            <a href="{{ url('/favoritos/'.session('selected_profile')->id) }}" class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fa-regular fa-heart-circle-check"></i>
                                <span>Favoritos</span>
                            </a>
                            <a href="{{ route('notifications') }}" class="flex items-center hidden px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fas fa-bell"></i>
                                <span>Notificações</span>
                                <span id="desktop-notification-badge-dropdown" class="flex items-center justify-center w-4 h-4 ml-auto text-xs font-bold text-white bg-red-500 rounded-full opacity-0 notification-badge">0</span>
                            </a>
                            <a href="{{ route('devices.index') }}" class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fas fa-mobile-alt"></i>
                                <span>Dispositivos</span>
                            </a>
                            <a href="{{ route('support.index') }}" class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fas fa-headset"></i>
                                <span>Suporte</span>
                            </a>
                            <div class="my-1 border-t border-zinc-700"></div>
                            <a href="{{ route('logout') }}"
                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                               class="flex items-center px-4 py-2 text-xs text-gray-300 transition-colors hover:bg-zinc-700">
                                <i class="w-5 mr-2 text-center fa-regular fa-right-from-bracket"></i>
                                <span>Sair da conta</span>
                            </a>
                        </div>
                    </div>
                </div>
                @else
                <!-- Botão de login para usuários não autenticados -->
                <a href="{{ route('login') }}" class="flex items-center px-4 py-2 font-medium text-black transition-transform duration-200 rounded-full bg-primary hover:bg-primary-dark hover:scale-105">
                    <i class="mr-2 fa-regular fa-right-to-bracket"></i>
                    <span>Entrar</span>
                </a>
                @endauth
            </div>
        </div>
    </header>

    <!-- Header Mobile com Logo -->
    <header id="mobile-header" class="fixed top-0 left-0 z-40 w-full py-3 lg:hidden">
        <div class="container flex items-center justify-center px-4 mx-auto">
            <!-- Logo -->
            <a href="{{ route('inicio') }}" class="flex items-center">
                <img class="object-cover w-auto h-10" src="{{ route('minilogo') }}" alt="Logo">
            </a>
        </div>
    </header>

    <!-- Mobile Navigation - Com fundo blur -->
    <nav class="fixed bottom-0 left-0 z-50 w-full bg-zinc-900/80 backdrop-blur-lg lg:hidden rounded-tl-2xl rounded-tr-2xl">
        <div class="container px-4 py-3 mx-auto">
            <!-- Bottom Navigation Menu -->
            <ul class="flex items-center justify-between">
                <li>
                    <a href="{{ route('inicio') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <i class="mb-1 text-xl fa-regular fa-house-blank"></i>
                        <span class="text-xs">Inicio</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('filmes.index') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <i class="mb-1 text-xl fa-regular fa-clapperboard-play"></i>
                        <span class="text-xs">Filmes</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('series.index') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <i class="mb-1 text-xl fa-regular fa-tv"></i>
                        <span class="text-xs">Séries</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('animes.index') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <i class="mb-1 text-xl fa-regular fa-fan"></i>
                        <span class="text-xs">Desenhos</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('livetv.index') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <i class="mb-1 text-xl fa-solid fa-signal-stream"></i>
                        <span class="text-xs">Canais</span>
                    </a>
                </li>
                <li class="relative" id="mobileMenuContainer">
                    @auth
                    <!-- Botão do Menu para usuários autenticados -->
                    <button id="mobileMenuButton" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <div class="w-6 h-6 overflow-hidden rounded-full">
                            <img class="object-cover w-full h-full"
                                 src="{{ session('selected_profile') && session('selected_profile')->avatar ? asset(session('selected_profile')->avatar) : asset('/avatars/avatar_default.png') }}"
                                 alt="Profile">
                        </div>
                        <span class="mt-1 text-xs">Mais</span>
                    </button>
                    @else
                    <!-- Botão de login para usuários não autenticados -->
                    <a href="{{ route('login') }}" class="flex flex-col items-center text-white transition-colors hover:text-primary">
                        <div class="flex items-center justify-center w-6 h-6 rounded-full bg-primary">
                            <i class="text-xs text-black fa-regular fa-right-to-bracket"></i>
                        </div>
                        <span class="mt-1 text-xs">Entrar</span>
                    </a>
                    @endauth
                </li>
            </ul>
        </div>
    </nav>

    <!-- Novo Dropdown Menu com expansão lateral e animações -->
    <div id="mobileDropdown" class="fixed inset-0 z-[60] hidden">
        <!-- Overlay com fundo escuro para fechar o menu -->
        <div id="menuOverlay" class="absolute inset-0 transition-opacity duration-300 bg-black opacity-0"></div>

        <!-- Menu Lateral Deslizante -->
        <div id="slideMenu" class="absolute top-0 left-0 h-full overflow-y-auto transition-transform duration-300 transform -translate-x-full rounded-tr-2xl rounded-br-2xl w-72 bg-zinc-900/90 backdrop-blur-md">
            <!-- Cabeçalho do Menu -->
            <div class="flex items-center justify-between p-6 border-b border-zinc-800/50">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 overflow-hidden rounded-full">
                        <img class="object-cover w-full h-full"
                             src="{{ session('selected_profile') && session('selected_profile')->avatar ? asset(session('selected_profile')->avatar) : asset('/avatars/avatar_default.png') }}"
                             alt="{{ session('selected_profile') ? session('selected_profile')->name : 'Perfil' }}">
                    </div>
                    <div>
                        <p class="font-medium text-white">{{ session('selected_profile') ? session('selected_profile')->name : 'Perfil' }}</p>
                        <p class="text-sm text-zinc-400">{{ auth()->user()->email ?? 'email@exemplo.com' }}</p>
                    </div>
                </div>
                <button id="closeMenuButton" class="p-1 text-white rounded-full hover:bg-zinc-800 hover:text-white">
                    <i class="text-xl fa-solid fa-xmark"></i>
                </button>
            </div>

            <!-- Itens do Menu -->
            <div class="py-2">
                <!-- Lista de perfis disponíveis para mobile - mostra apenas se o usuário tiver múltiplos perfis -->
                @if(auth()->check() && count(auth()->user()->profiles) > 1)
                    <div class="px-6 py-2 mb-2 border-b border-zinc-800/50">
                        <p class="mb-2 text-xs font-medium text-zinc-500">Trocar de perfil</p>
                        <div class="flex flex-wrap gap-3">
                            @foreach(auth()->user()->profiles as $profile)
                                @if(!session('selected_profile') || $profile->id != session('selected_profile')->id)
                                    <a href="{{ url('/select-profile/'.$profile->id) }}" class="flex flex-col items-center justify-center">
                                        <div class="w-12 h-12 mb-1 overflow-hidden transition-transform border-2 border-transparent rounded-full hover:border-primary hover:scale-110">
                                            <img class="object-cover w-full h-full" src="{{ $profile->avatar ? asset($profile->avatar) : asset('/avatars/avatar_default.png') }}" alt="{{ $profile->name }}">
                                        </div>
                                        <span class="text-xs text-white">{{ $profile->name }}</span>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                <a href="{{ route('search') }}" class="flex items-center px-6 py-3 text-gray-300 transition-colors hover:bg-zinc-800">
                    <i class="w-5 mr-3 text-center fas fa-search"></i>
                    <span>Pesquisar</span>
                </a>
                <a href="{{ route('user.profile') }}" class="flex items-center px-6 py-3 text-gray-300 transition-colors hover:bg-zinc-800">
                    <i class="w-5 mr-3 text-center fa-regular fa-user-vneck"></i>
                    <span>Minha Conta</span>
                </a>
                <a href="{{ url('/favoritos/'.session('selected_profile')->id) }}" class="flex items-center px-6 py-3 text-gray-300 transition-colors hover:bg-zinc-800">
                    <i class="w-5 mr-3 text-center fa-regular fa-heart-circle-check"></i>
                    <span>Favoritos</span>
                </a>
                <a href="{{ route('choose-profile') }}" class="flex items-center px-6 py-3 text-gray-300 transition-colors hover:bg-zinc-800">
                    <i class="w-5 mr-3 text-center fa-solid fa-user-gear"></i>
                    <span>Gerenciar perfis</span>
                </a>
            </div>

            <!-- Footer com opção de logout -->
            <div class="absolute bottom-0 left-0 w-full p-6 border-t border-zinc-800/50">
                <a href="{{ route('logout') }}"
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                   class="flex items-center w-full py-3 text-gray-300 transition-colors hover:text-primary">
                    <i class="w-5 mr-3 text-center fa-regular fa-right-from-bracket"></i>
                    <span>Sair da conta</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Logout Form -->
    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
        @csrf
    </form>

    <!-- Menu Script para controlar o dropdown lateral com animações -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuButton = document.getElementById('mobileMenuButton');
            const mobileDropdown = document.getElementById('mobileDropdown');
            const menuOverlay = document.getElementById('menuOverlay');
            const slideMenu = document.getElementById('slideMenu');
            const closeMenuButton = document.getElementById('closeMenuButton');
            const desktopHeader = document.getElementById('desktop-header');

            // Função para controlar a transparência do header baseado no scroll
            function controlHeaderTransparency() {
                if (window.scrollY > 10) {
                    // Quando rolado, adiciona fundo com blur
                    desktopHeader.classList.remove('header-transparent');
                    desktopHeader.classList.add('header-blur');
                } else {
                    // Quando no topo, mantém transparente
                    desktopHeader.classList.remove('header-blur');
                    desktopHeader.classList.add('header-transparent');
                }
            }

            // Verificar posição inicial da página
            controlHeaderTransparency();

            // Adicionar listener para o evento de scroll
            window.addEventListener('scroll', controlHeaderTransparency);

            // Função para abrir o menu com animação
            function openMenu() {
                // Mostrar o container principal
                mobileDropdown.classList.remove('hidden');

                // Permitir que o DOM atualize antes de adicionar as classes de transição
                setTimeout(() => {
                    // Animar o overlay (fade in)
                    menuOverlay.classList.add('opacity-50');

                    // Animar o menu (slide in)
                    slideMenu.classList.remove('-translate-x-full');
                    slideMenu.classList.add('translate-x-0');

                    // Impedir rolagem no body
                    document.body.style.overflow = 'hidden';
                }, 10);
            }

            // Função para fechar o menu com animação
            function closeMenu() {
                // Animar o overlay (fade out)
                menuOverlay.classList.remove('opacity-50');
                menuOverlay.classList.add('opacity-0');

                // Animar o menu (slide out)
                slideMenu.classList.remove('translate-x-0');
                slideMenu.classList.add('-translate-x-full');

                // Restaurar rolagem no body
                document.body.style.overflow = '';

                // Aguardar o fim da animação antes de esconder completamente
                setTimeout(() => {
                    mobileDropdown.classList.add('hidden');
                }, 300); // Tempo igual à duração da transição
            }

            // Event listeners
            mobileMenuButton.addEventListener('click', openMenu);
            closeMenuButton.addEventListener('click', closeMenu);
            menuOverlay.addEventListener('click', closeMenu);

            // Fechar menu quando tecla ESC é pressionada
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && !mobileDropdown.classList.contains('hidden')) {
                    closeMenu();
                }
            });

            // Eventos de links dentro do menu
            slideMenu.querySelectorAll('a').forEach(link => {
                // Não fechar imediatamente para permitir que as ações dos links ocorram
                link.addEventListener('click', function(e) {
                    // Se não for o logout, que tem seu próprio manipulador
                    if (!this.getAttribute('onclick')) {
                        setTimeout(closeMenu, 150);
                    }
                });
            });

            // Verificar notificações não lidas
            function checkNotifications() {
                fetch('{{ route("api.notifications.count") }}', {
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    const count = data.count;

                    // Atualizar os badges de notificação
                    const badges = document.querySelectorAll('.notification-badge');

                    badges.forEach(badge => {
                        if (count > 0) {
                            badge.textContent = count > 99 ? '99+' : count;
                            badge.classList.remove('opacity-0');
                            badge.classList.add('opacity-100');
                        } else {
                            badge.classList.remove('opacity-100');
                            badge.classList.add('opacity-0');
                        }
                    });
                })
                .catch(error => console.error('Erro ao verificar notificações:', error));
            }

            // Verificar notificações ao carregar a página
            checkNotifications();

            // Verificar notificações periodicamente (a cada 5 minutos)
            setInterval(checkNotifications, 300000);
        });
    </script>

    <main class="flex-1">
        <div>
            @yield('content')
        </div>
    </main>

    <!-- Adicionar script para inicializar carrosséis após o conteúdo ser carregado -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Ocultar o loader na carga inicial
            setTimeout(() => {
                const loader = document.getElementById('page-transition-loader');
                if (loader) {
                    loader.classList.add('hidden');
                }
            }, 500);

            // Carregar scripts não críticos de forma assíncrona
            function loadAsyncScript(src) {
                const script = document.createElement('script');
                script.src = src;
                script.async = true;
                document.body.appendChild(script);
            }

            // Carregar scripts não essenciais após um pequeno atraso
            setTimeout(() => {
                loadAsyncScript('{{ asset("js/carousel-init.js") }}');
                loadAsyncScript('{{ asset("js/random-content-player.js") }}');
            }, 600);
        });
    </script>
</body>
</html>
