<head>
    <!-- Outras tags head que você possa ter -->

    <!-- Inclua o CSS do Tiny Slider -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.3/tiny-slider.css">

    
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    
    <link rel="stylesheet" href="/css/web.css">
    
</head>


@php

use Carbon\Carbon

@endphp

<section class="container">
    <div class="slider">
        <!-- Loop através dos dados recebidos da variável $featureds -->
        @foreach($featureds as $featured)
            <a href="{{ url('/filme/' . $featured->featured_id) }}" class="featured-item" style="background-image: linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent), url('{{$featured['backdrop_path_tv']}}'); background-size: cover;
                background-position: center center;">
                <img class="minilogo" src="{{ asset($featured['miniposter']) }}" alt="Miniposter">
                <div class="informacoes" >
                    <p class="imdb">{{ $featured->vote_average }}<i class="fas fa-star"></i></p>
                    <p class="genero">{{ $featured->genre }}</p>
                    <li>{{ Carbon::createFromFormat('Y-m-d', $featured->release_date)->format('Y') }}</li>
                    <p class="sinopse">{{ $featured->overview }}</p>
                </div>
            </a>
        @endforeach
    </div>
</section>



<script src="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.3/min/tiny-slider.js"></script>
<script>
    // Esperar até que o DOM esteja totalmente carregado
    document.addEventListener('DOMContentLoaded', function () {
        // Selecionar o elemento que contém o slider (no nosso caso, é a div com a classe "slider")
        var sliderElement = document.querySelector('.slider');

        // Inicializar o slider
        var slider = tns({
            container: sliderElement,
            items: 1,
            slideBy: 'page',
            autoplay: true,
            autoplayButtonOutput: false,
            controls: false,
            nav: false,
            
        });
    });
</script>