<!-- resources/views/movies.blade.php -->

@section('content')
    <h1>Filmes</h1>
    <table>
        <thead>
            <tr>
                <th>Título</th>
                <th>Vídeos</th>
                <th>Ativo</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($movies as $movie)
                <tr>
                    <td>{{ $movie->title }}</td>
                    <td>
                        <ul>
                            @foreach ($movie->videos as $video)
                                <li>{{ $video->link }}</li>
                            @endforeach
                        </ul>
                    </td>
                    <td>{{ $movie->active ? 'Sim' : 'Não' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
