<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escolha um navegador</title>
    <meta name="referrer" content="no-referrer">
    <style>
        body {
            background-color: #121212;
            color: white;
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 40px 20px;
            margin: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        h2 {
            margin-bottom: 30px;
            font-size: 24px;
        }
        .button-container {
            display: flex;
            flex-direction: column;
            gap: 15px;
            max-width: 300px;
            width: 100%;
            margin: 20px 0;
        }
        .browser-button {
            display: block;
            padding: 15px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: bold;
            border: 1px solid;
            transition: background-color 0.3s;
        }
        .firefox {
            color: #FF9500;
            border-color: #FF9500;
            background-color: rgba(255,149,0,0.1);
        }
        .firefox:hover {
            background-color: rgba(255,149,0,0.2);
        }
        .chrome {
            color: #4285F4;
            border-color: #4285F4;
            background-color: rgba(66,133,244,0.1);
        }
        .chrome:hover {
            background-color: rgba(66,133,244,0.2);
        }
        .default {
            color: #FFC107;
            border-color: #FFC107;
            background-color: rgba(255,193,7,0.1);
        }
        .default:hover {
            background-color: rgba(255,193,7,0.2);
        }
        .manual-url {
            margin-top: 20px;
            font-size: 14px;
            opacity: 0.8;
        }
        .url-highlight {
            font-weight: bold;
            color: #FFC107;
        }
    </style>
</head>
<body>
    <h2>Para continuar, escolha um navegador</h2>

    <div class="button-container">
        <a href="intent://goldflix.pro/#Intent;scheme=https;package=org.mozilla.firefox;end" class="browser-button firefox">
            Abrir no Firefox
        </a>
        <a href="intent://goldflix.pro/#Intent;scheme=https;package=com.android.chrome;end" class="browser-button chrome">
            Abrir no Chrome
        </a>
        <a href="intent://goldflix.pro/#Intent;scheme=https;action=android.intent.action.VIEW;end" class="browser-button default">
            Abrir no navegador padrão
        </a>
    </div>
    
    <p class="manual-url">
        Caso não funcione, digite <span class="url-highlight">goldflix.pro</span> no navegador de sua preferência
    </p>
</body>
</html>
