<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Escolha um navegador</title>
    <style>
        body {
            background-color: #121212;
            color: white;
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 40px 20px;
            margin: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        h2 {
            margin-bottom: 30px;
        }
        .browser-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
            max-width: 300px;
            width: 100%;
        }
        .browser-button {
            padding: 20px;
            border-radius: 10px;
            text-decoration: none;
            font-weight: bold;
            border: 1px solid;
            transition: transform 0.2s, opacity 0.2s;
        }
        .browser-button:hover, .browser-button:active {
            transform: translateY(-2px);
            opacity: 0.9;
        }
        .firefox {
            color: #FF9500;
            background-color: rgba(255,149,0,0.1);
            border-color: #FF9500;
        }
        .chrome {
            color: #4285F4;
            background-color: rgba(66,133,244,0.1);
            border-color: #4285F4;
        }
        .default-browser {
            color: #FFC107;
            background-color: rgba(255,193,7,0.1);
            border-color: #FFC107;
        }
        .manual-url {
            margin-top: 30px;
            font-size: 14px;
        }
        .site-url {
            color: #FFC107;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <h2>Escolha um navegador para acessar o novo site</h2>

    <div class="browser-list">
        <a href="intent://goldflix.pro/#Intent;scheme=https;package=org.mozilla.firefox;end" class="browser-button firefox">
            Abrir no Firefox
        </a>
        <a href="intent://goldflix.pro/#Intent;scheme=https;package=com.android.chrome;end" class="browser-button chrome">
            Abrir no Chrome
        </a>
        <a href="intent://goldflix.pro/#Intent;scheme=https;action=android.intent.action.VIEW;end" class="browser-button default-browser">
            Abrir no navegador padrão
        </a>
    </div>

    <p class="manual-url">
        Se os botões acima não funcionarem, acesse manualmente: <span class="site-url">goldflix.pro</span>
    </p>
</body>
</html>
