<div class="relative rounded-lg overflow-hidden bg-zinc-900 h-full">
    <img src="{{ $item->poster_path }}" alt="{{ $item->display_name }}"
         class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">

    <div class="absolute inset-0 bg-gradient-to-t from-black/80 to-transparent"></div>

    <div class="absolute top-2 right-2">
        @if($item->is_new)
            <span class="bg-green-500 text-black text-xs font-bold px-2 py-1 rounded-full">NOVO</span>
        @else
            <span class="bg-amber-500 text-black text-xs font-bold px-2 py-1 rounded-full">ATUALIZADO</span>
        @endif
    </div>

    <div class="absolute left-0 right-0 bottom-0 p-3">
        <h4 class="font-medium truncate">{{ $item->display_name }}</h4>
        <p class="text-xs text-gray-400">
            {{ Carbon\Carbon::parse($item->is_new ? $item->created_at : $item->updated_at)->format('d/m/Y') }}
        </p>

        @if($item->content_type == 'movie')
            <span class="inline-block mt-2 text-xs px-2 py-0.5 bg-blue-900/50 text-blue-300 rounded">Filme</span>
        @elseif($item->content_type == 'serie')
            <span class="inline-block mt-2 text-xs px-2 py-0.5 bg-red-900/50 text-red-300 rounded">Série</span>
        @elseif($item->content_type == 'anime')
            <span class="inline-block mt-2 text-xs px-2 py-0.5 bg-purple-900/50 text-purple-300 rounded">Anime</span>
        @endif
    </div>
</div>
