<div class="mt-12 episode-list">
    @if($seasons && count($seasons) > 0)
        <!-- Season Selector - Grid Horizontal -->
        <div class="mb-8">
            <h3 class="mb-4 text-lg font-semibold">Temporadas</h3>
            <div class="flex gap-2 pb-2 overflow-x-auto scrollbar-hide">
                @foreach ($seasons as $season)
                    <button
                        type="button"
                        data-season="{{ $season->season_number }}"
                        class="season-button whitespace-nowrap px-5 py-2 rounded-full text-sm font-medium transition-colors duration-300 min-w-[100px] flex-shrink-0
                               {{ $season->season_number == 1 ? 'bg-primary text-black' : 'bg-zinc-800 text-white hover:bg-zinc-700' }}">
                        {{ $season->name }}
                    </button>
                @endforeach
            </div>
        </div>

        <!-- Episodes Grid -->
        @foreach ($seasons as $season)
            <div class="season-episodes {{ $season->season_number != 1 ? 'hidden' : '' }}"
                 id="season_{{ $season->season_number }}">
                <div class="space-y-4">
                    @foreach ($season->episodes as $episode)
                        <div class="overflow-hidden transition duration-300 bg-zinc-900/50 rounded-xl hover:bg-zinc-800/50 episode-item"
                             data-episode-id="{{ $episode->id }}"
                             data-episode="{{ json_encode($episode) }}">
                            @if (count($episode->videos) > 0)
                                <div class="flex flex-col cursor-pointer sm:flex-row"
                                     onclick="SerieApp.openServerSelection({{ json_encode($episode) }})">
                                    <!-- Episode Thumbnail -->
                                    <div class="w-full sm:w-48 aspect-video sm:aspect-[16/9]">
                                        <img src="{{ $episode->still_path ?: $serie->backdrop_path }}"
                                             alt="{{ $episode->name }}"
                                             class="object-cover w-full h-full"
                                             loading="lazy">
                                    </div>
                                    <!-- Episode Info -->
                                    <div class="flex-1 p-4">
                                        <div class="flex items-center gap-2 mb-2">
                                            <span class="px-2 py-1 text-sm rounded bg-zinc-800">E{{ $episode->episode_number }}</span>
                                            <h4 class="text-lg font-medium">{{ $episode->name }}</h4>
                                        </div>
                                        <p class="text-sm text-gray-400 line-clamp-2">{{ $episode->overview }}</p>
                                    </div>
                                </div>
                            @else
                                <div class="p-4 text-center text-gray-500">
                                    <i class="mr-2 fas fa-clock"></i>
                                    Episódio indisponível no momento
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach
    @else
        <div class="p-6 text-center bg-zinc-900/50 rounded-xl">
            <p class="text-gray-500">Nenhuma temporada disponível para esta série.</p>
        </div>
    @endif
</div>

<!-- JavaScript para controle das temporadas -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Selecionar todas as temporadas
        const seasonButtons = document.querySelectorAll('.season-button');

        // Adicionar evento de clique para cada botão
        seasonButtons.forEach(button => {
            button.addEventListener('click', function() {
                const seasonNumber = this.dataset.season;

                // Remover classe ativa de todos os botões
                seasonButtons.forEach(btn => {
                    btn.classList.remove('bg-primary', 'text-black');
                    btn.classList.add('bg-zinc-800', 'text-white', 'hover:bg-zinc-700');
                });

                // Adicionar classe ativa ao botão clicado
                this.classList.remove('bg-zinc-800', 'text-white', 'hover:bg-zinc-700');
                this.classList.add('bg-primary', 'text-black');

                // Esconder todas as temporadas
                document.querySelectorAll('.season-episodes').forEach(season => {
                    season.classList.add('hidden');
                });

                // Mostrar a temporada selecionada
                document.getElementById(`season_${seasonNumber}`).classList.remove('hidden');

                // Atualizar o estado no objeto SerieApp se existir
                if (typeof SerieApp !== 'undefined') {
                    SerieApp.state.currentSeason = seasonNumber;
                }
            });
        });
    });
</script>
