<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $livetv->name }} - TV Ao Vivo</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
    <style>
        .image-wrapper {
            position: relative;
            overflow: hidden;
            border-radius: 0.5rem;
            border: 2px solid transparent;
            transition: border-color 0.3s ease, transform 0.3s ease;
        }

        .image-wrapper:hover {
            border-color: white;
            transform: scale(1.05);
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    @include('layouts._partials.header')

    <div class="container px-4 py-20 mx-auto">
        <!-- Player de Vídeo -->
        <div class="w-full mb-8 overflow-hidden rounded-lg bg-zinc-900">
            <div class="aspect-video">
                @if($livetv->videos && count($livetv->videos) > 0)
                    @if($livetv->videos[0]->embed == 1)
                        <iframe src="{{ $livetv->videos[0]->link }}"
                                class="w-full h-full"
                                allowfullscreen></iframe>
                    @else
                        <video id="video-player" controls autoplay class="w-full h-full">
                            <source src="{{ $livetv->videos[0]->link }}" type="application/x-mpegURL">
                            Seu navegador não suporta a reprodução de vídeos.
                        </video>
                    @endif
                @else
                    <div class="flex items-center justify-center w-full h-full">
                        <p class="text-lg text-zinc-400">Nenhum stream disponível para este canal.</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Informações do Canal -->
        <div class="mb-12">
            <h1 class="mb-2 text-3xl font-bold">{{ $livetv->name }}</h1>
            @if($livetv->genres && count($livetv->genres) > 0 && isset($livetv->genres[0]->genre))
                <p class="text-zinc-400">Categoria: {{ $livetv->genres[0]->genre->name }}</p>
            @endif
        </div>

        <!-- Canais Relacionados -->
        <div>
            <h2 class="mb-6 text-xl font-bold">Canais Relacionados</h2>
            <div class="grid grid-cols-2 gap-4 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                @foreach ($filmesRelacionados as $movie)
                    <a href="{{ route('livetv.show', $movie->id) }}" class="block group">
                        <div class="relative overflow-hidden rounded-lg image-wrapper">
                            <img src="{{ $movie->poster_path }}"
                                 alt="{{ $movie->name }}"
                                 class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105"
                                 loading="lazy">
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent"></div>
                        </div>
                        <h3 class="mt-2 text-sm font-medium text-center text-white">{{ $movie->name }}</h3>
                    </a>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        var videoPlayer = document.getElementById('video-player');
        if (videoPlayer) {
            if (Hls.isSupported()) {
                var hls = new Hls();
                var videoSrc = videoPlayer.querySelector('source').src;

                hls.loadSource(videoSrc);
                hls.attachMedia(videoPlayer);

                hls.on(Hls.Events.MANIFEST_PARSED, function() {
                    videoPlayer.play();
                });
            } else if (videoPlayer.canPlayType('application/vnd.apple.mpegurl')) {
                // Safari suporta HLS nativamente
                videoPlayer.src = videoPlayer.querySelector('source').src;
                videoPlayer.addEventListener('loadedmetadata', function() {
                    videoPlayer.play();
                });
            }
        }
    });
    </script>
</body>
</html>
