<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Redefinir Senha - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="flex items-center justify-center min-h-screen p-4 text-white bg-black font-poppins">
    <div class="w-full max-w-md p-8 rounded-lg shadow-xl bg-zinc-900/80">
        <!-- Logo -->
        <div class="flex justify-center mb-8">
            <div class="flex items-center justify-center w-32 h-24">
            <img src="{{ route('minilogo')}}" alt="logo" class="w-32" onload="this.parentElement.classList.remove('animate-pulse', 'bg-zinc-800')">
            </div>
        </div>

        <h2 class="mb-4 text-2xl font-bold text-center">Redefinir Senha</h2>

        <p class="mb-8 text-center text-zinc-400">
            Você receberá um email com um link para redefinir sua senha.
            Verifique também sua caixa de SPAM.
        </p>

        <!-- Alertas -->
        @if (session('status'))
            <div class="flex items-center p-4 mb-6 text-green-500 border border-green-500 rounded-lg bg-green-500/10">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                </svg>
                {{ session('status') }}
            </div>
        @endif

        @if($errors->any())
            <div class="p-4 mb-6 text-red-500 border border-red-500 rounded-lg bg-red-500/10">
                <ul class="list-disc list-inside">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- Formulário -->
        <form method="POST" action="{{ route('password.email') }}" class="space-y-6">
            @csrf

            <div>
                <input
                    type="email"
                    name="email"
                    id="email"
                    value="{{ old('email') }}"
                    placeholder="Endereço de Email"
                    required
                    autofocus
                    class="w-full px-6 py-3 text-white transition duration-300 border rounded-full bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary"
                >
            </div>

            <button
                type="submit"
                class="w-full px-4 py-3 font-semibold text-black transition duration-300 rounded-full bg-primary hover:scale-105"
            >
                Enviar Link de Redefinição
            </button>
        </form>

        <div class="mt-6 text-center">
            <a href="{{ route('login') }}" class="text-sm transition duration-300 text-zinc-400 hover:text-white">
                Voltar para o Login
            </a>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>
</body>
</html>
