<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link rel="stylesheet" href="/css/web.css">
</head>
<body class="body-fav">

<section class="conteiner-login">
    <div class="login-container">
    @if($errors->any())
        <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if (session('error'))
            <div class="alert alert-danger">
                {{ session('error') }}
            </div>
        @endif

            <!-- Mostrar mensagem de sucesso se estiver definida -->
        @if(session('status'))
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
        @endif
        <div class="logo-login" >
            <img src="/public{{ route('minilogo') }}" alt="logo" >
        </div>
        <h2>Entrar</h2>
        <form action="{{ route('login.premium') }}" method="post">
            @csrf

            <div>
                <input placeholder="Endereço de Email" class="input-profile" type="email" name="email" id="email" required>
            </div>
            <br>
            <div>
                <input placeholder="Senha" class="password-input" type="password" name="password" id="password" required>
            </div>
            <br>
            <div>
                <button type="submit" class="btn-login">Entrar</button>
            </div>

    </div>

</section>

</body>
</html>
