<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="flex items-center justify-center min-h-screen p-4 text-white bg-black font-poppins">
    <div class="w-full max-w-md p-8 rounded-lg shadow-xl bg-zinc-900/80">
        <!-- Alertas -->
        @if($errors->any())
            <div class="p-4 mb-4 text-red-500 border border-red-500 rounded-lg bg-red-500/10">
                <ul class="list-disc list-inside">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        @if (session('error'))
            <div class="p-4 mb-4 text-red-500 border border-red-500 rounded-lg bg-red-500/10">
                {{ session('error') }}
            </div>
        @endif

        @if(session('status'))
            <div class="p-4 mb-4 text-green-500 border border-green-500 rounded-lg bg-green-500/10">
                {{ session('status') }}
            </div>
        @endif

        <!-- Logo -->
        <div class="flex justify-center mb-8">
            <div class="flex items-center justify-center w-32 h-24">
            <img src="{{ route('minilogo')}}" alt="logo" class="w-32" onload="this.parentElement.classList.remove('animate-pulse', 'bg-zinc-800')">
            </div>
        </div>

        <h2 class="mb-8 text-2xl font-bold text-center">Entrar</h2>

        <!-- Formulário -->
        <form action="{{ route('login') }}" method="post" class="space-y-6">
            @csrf

            <div>
                <input
                    placeholder="Endereço de Email"
                    type="email"
                    name="email"
                    id="email"
                    required
                    class="w-full px-6 py-3 text-white transition duration-300 border rounded-full bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary"
                >
            </div>

            <div>
                <input
                    placeholder="Senha"
                    type="password"
                    name="password"
                    id="password"
                    required
                    class="w-full px-6 py-3 text-white transition duration-300 border rounded-full bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary"
                >
            </div>

            <button
                type="submit"
                class="w-full px-4 py-3 font-semibold text-black transition duration-300 rounded-full bg-primary hover:scale-105"
            >
                Entrar
            </button>

            <div class="text-center">
                <a href="{{ route('password.request') }}" class="text-sm transition duration-300 text-zinc-400 hover:text-white">
                    Esqueceu a senha?
                </a>
            </div>
        </form>

        <div class="w-full mt-8 text-center">
            <a href="{{ route('register') }}" class="px-4 py-3 text-white transition duration-300 border rounded-full border-primary hover:bg-primary hover:text-black">
            Criar uma Conta
            </a>
        </div>
    </div>

    <!-- Fundo com gradiente (opcional) -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>
</body>
</html>
