<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criar Perfil - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
    <style>
        input[type="radio"] {
            display: none;
        }
        input[type="radio"]:checked + label img {
            border-color: primary;
            transform: scale(1.05);
        }
        /* Toast Styles */
        .toast {
            visibility: hidden;
            min-width: 250px;
            text-align: center;
            border-radius: 9999px;
            padding: 16px;
            position: fixed;
            z-index: 50;
            left: 50%;
            transform: translateX(-50%);
            top: 30px;
            font-weight: 500;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .toast.success {
            background-color: rgba(43, 241, 74, 0.9);
            color: #000;
        }

        .toast.error {
            background-color: rgba(239, 68, 68, 0.9);
            color: #fff;
        }

        .toast.show {
            visibility: visible;
            animation: fadein 0.5s, fadeout 0.5s 4.5s;
        }

        @keyframes fadein {
            from {top: 0; opacity: 0;}
            to {top: 30px; opacity: 1;}
        }

        @keyframes fadeout {
            from {top: 30px; opacity: 1;}
            to {top: 0; opacity: 0;}
        }
    </style>
</head>
<body class="min-h-screen text-white bg-black font-poppins">
    @if (session('response'))
        <div id="toast" class="toast {{ session('response')['type'] === 'success' ? 'success' : 'error' }}">
            {{ session('response')['message'] }}
        </div>
    @endif
    <div class="container flex flex-col items-center justify-center min-h-screen px-4 py-20 mx-auto">
        <div class="w-full max-w-4xl p-8 shadow-xl bg-zinc-900/80 rounded-2xl">
            <h1 class="mb-12 text-3xl font-bold text-center">Criar Novo Perfil</h1>

            <form method="POST" action="{{ url('/user/profile/create') }}" class="space-y-8">
                @csrf

                <!-- Nome do Perfil -->
                <div class="max-w-md mx-auto">
                    <input
                        placeholder="Nome de Perfil"
                        type="text"
                        id="name"
                        name="name"
                        required
                        class="w-full px-6 py-3 text-white transition duration-300 border rounded-full bg-zinc-800 border-zinc-700 placeholder-zinc-400 focus:outline-none focus:border-primary"
                    >
                </div>

                <!-- Seleção de Avatar -->
                <div class="mt-8">
                    <h4 class="mb-6 text-xl font-medium text-center">Escolha um Avatar</h4>

                    <div class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 lg:grid-cols-8 gap-4 max-h-[400px] overflow-y-auto p-4">
                        @foreach ($avatars as $avatar)
                            <div class="aspect-square">
                                <input
                                    type="radio"
                                    id="avatar{{ $loop->index }}"
                                    name="avatar"
                                    value="{{ $avatar }}"
                                    required
                                >
                                <label for="avatar{{ $loop->index }}" class="block cursor-pointer">
                                    <img
                                        loading="lazy"
                                        src="{{ asset($avatar) }}"
                                        alt="Avatar"
                                        class="object-cover w-full h-full transition duration-300 border-4 border-transparent rounded-full hover:border-primary/50"
                                    >
                                </label>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Botão de Submit -->
                <div class="mt-8 text-center">
                    <button
                        type="submit"
                        class="inline-block px-8 py-3 font-semibold text-black transition duration-300 rounded-full bg-primary hover:scale-105"
                    >
                        Criar Perfil
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Fundo com gradiente -->
    <div class="fixed inset-0 -z-10 bg-gradient-to-br from-zinc-900 to-black"></div>

    <script>
        function showToast() {
            var toast = document.getElementById("toast");
            if (toast) {
                toast.className = toast.className + " show";
                setTimeout(function(){
                    toast.className = toast.className.replace(" show", "");
                }, 5000);
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            showToast();
        });
    </script>
</body>
</html>
