<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Ativar TV</title>
</head>
<body>
    <div class="container">
        <h1>Usuários</h1>
        <form action="{{ route('users.index') }}" method="GET">
            <input type="text" name="search" placeholder="Pesquisar por email" value="{{ request('search') }}">
            <button type="submit">Pesquisar</button>
        </form>
        <table>
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Email</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($users as $user)
                <tr>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>
                        <form action="{{ route('users.update', $user->id) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <input type="checkbox" name="tv_access" value="1" {{ $user->tv_access ? 'checked' : '' }}> Ativar TV Access
                            <input type="date" name="expired_in_tv" value="{{ $user->expired_in_tv->format('Y-m-d') }}">
                            <button type="submit">Atualizar</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        {{ $users->links() }}
    </div>
</body>
</html>