@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{ asset('assets/css/custom-admin-support.css') }}">
<style>
    /* Estilos específicos para a página de suporte com fundo branco */
    .ticket-card {
        background-color: #f8f9fa;
        border: 1px solid #e9ecef;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .ticket-header {
        background-color: #f1f3f5;
        border-bottom: 1px solid #e9ecef;
    }

    .ticket-row:hover {
        background-color: #f2f4f6 !important;
    }

    .status-badge-open {
        background-color: rgba(0, 123, 255, 0.1);
        color: #0069d9;
    }

    .status-badge-progress {
        background-color: rgba(255, 193, 7, 0.1);
        color: #d39e00;
    }

    .status-badge-resolved {
        background-color: rgba(40, 167, 69, 0.1);
        color: #1e7e34;
    }
</style>
@endsection

@section('content')
<div class="container px-4 py-20 mx-auto">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-800">Gerenciamento de Suporte</h1>
        <p class="mt-2 text-gray-600">Gerencie todos os tickets de suporte dos usuários.</p>
    </div>

    @if(session('success'))
        <div class="px-4 py-3 mb-6 text-green-700 bg-green-100 border border-green-200 rounded">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="px-4 py-3 mb-6 text-red-700 bg-red-100 border border-red-200 rounded">
            {{ session('error') }}
        </div>
    @endif

    <!-- Dashboard Stats -->
    @php
        $totalTickets = $openTickets->total() + $inProgressTickets->total() + $resolvedTickets->total();
    @endphp
    @include('admin.support._statistics', ['totalTickets' => $totalTickets])

    <!-- Tabs - Modificado para evitar a navegação incorreta -->
    <div class="mb-6 border-b border-gray-200">
        <ul class="flex flex-wrap -mb-px">
            <li class="mr-2">
                <button type="button"
                       class="inline-block p-4 text-primary border-b-2 rounded-t-lg border-primary active tab-button"
                       data-tab="abertos">
                    Tickets Abertos
                    <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-blue-100 text-blue-600">{{ $openTickets->total() }}</span>
                </button>
            </li>
            <li class="mr-2">
                <button type="button"
                       class="inline-block p-4 text-gray-500 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 tab-button"
                       data-tab="em_andamento">
                    Em Andamento
                    <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-yellow-100 text-yellow-600">{{ $inProgressTickets->total() }}</span>
                </button>
            </li>
            <li class="mr-2">
                <button type="button"
                       class="inline-block p-4 text-gray-500 border-b-2 border-transparent rounded-t-lg hover:text-gray-600 hover:border-gray-300 tab-button"
                       data-tab="resolvidos">
                    Resolvidos
                    <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-green-100 text-green-600">{{ $resolvedTickets->total() }}</span>
                </button>
            </li>
        </ul>
    </div>

    <!-- Tab Content -->
    <div id="abertos" class="tab-content">
        @if($openTickets->count() > 0)
            <div class="overflow-hidden bg-white rounded-lg shadow ticket-card">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-left ticket-header">
                                <th class="px-6 py-4 text-gray-700">#</th>
                                <th class="px-6 py-4 text-gray-700">Usuário</th>
                                <th class="px-6 py-4 text-gray-700">Assunto</th>
                                <th class="px-6 py-4 text-gray-700">Categoria</th>
                                <th class="px-6 py-4 text-gray-700">Data</th>
                                <th class="px-6 py-4 text-gray-700">Ações</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($openTickets as $ticket)
                                <tr class="transition duration-150 ticket-row hover:bg-gray-50">
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->id }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->user->name }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->subject }}</td>
                                    <td class="px-6 py-4 text-gray-800">
                                        @php
                                            $categories = \App\Models\SupportTicket::getCategories();
                                        @endphp
                                        {{ $categories[$ticket->category] ?? $ticket->category }}
                                    </td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->created_at->format('d/m/Y H:i') }}</td>
                                    <td class="px-6 py-4">
                                        <a href="{{ route('admin.support.show', $ticket->id) }}" class="flex items-center text-primary hover:text-primary-dark">
                                            <i class="mr-1 mdi mdi-eye"></i>
                                            <span>Responder</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                    {{ $openTickets->links() }}
                </div>
            </div>
        @else
            <div class="p-8 text-center bg-white rounded-lg shadow ticket-card">
                <p class="text-gray-600">Não há tickets abertos no momento.</p>
            </div>
        @endif
    </div>

    <div id="em_andamento" class="hidden tab-content">
        @if($inProgressTickets->count() > 0)
            <div class="overflow-hidden bg-white rounded-lg shadow ticket-card">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-left ticket-header">
                                <th class="px-6 py-4 text-gray-700">#</th>
                                <th class="px-6 py-4 text-gray-700">Usuário</th>
                                <th class="px-6 py-4 text-gray-700">Assunto</th>
                                <th class="px-6 py-4 text-gray-700">Categoria</th>
                                <th class="px-6 py-4 text-gray-700">Atualizado</th>
                                <th class="px-6 py-4 text-gray-700">Ações</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($inProgressTickets as $ticket)
                                <tr class="transition duration-150 ticket-row hover:bg-gray-50">
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->id }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->user->name }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->subject }}</td>
                                    <td class="px-6 py-4 text-gray-800">
                                        @php
                                            $categories = \App\Models\SupportTicket::getCategories();
                                        @endphp
                                        {{ $categories[$ticket->category] ?? $ticket->category }}
                                    </td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->updated_at->format('d/m/Y H:i') }}</td>
                                    <td class="px-6 py-4">
                                        <a href="{{ route('admin.support.show', $ticket->id) }}" class="flex items-center text-primary hover:text-primary-dark">
                                            <i class="mr-1 mdi mdi-eye"></i>
                                            <span>Responder</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                    {{ $inProgressTickets->links() }}
                </div>
            </div>
        @else
            <div class="p-8 text-center bg-white rounded-lg shadow ticket-card">
                <p class="text-gray-600">Não há tickets em andamento no momento.</p>
            </div>
        @endif
    </div>

    <div id="resolvidos" class="hidden tab-content">
        @if($resolvedTickets->count() > 0)
            <div class="overflow-hidden bg-white rounded-lg shadow ticket-card">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-left ticket-header">
                                <th class="px-6 py-4 text-gray-700">#</th>
                                <th class="px-6 py-4 text-gray-700">Usuário</th>
                                <th class="px-6 py-4 text-gray-700">Assunto</th>
                                <th class="px-6 py-4 text-gray-700">Categoria</th>
                                <th class="px-6 py-4 text-gray-700">Resolvido em</th>
                                <th class="px-6 py-4 text-gray-700">Ações</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            @foreach($resolvedTickets as $ticket)
                                <tr class="transition duration-150 ticket-row hover:bg-gray-50">
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->id }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->user->name }}</td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->subject }}</td>
                                    <td class="px-6 py-4 text-gray-800">
                                        @php
                                            $categories = \App\Models\SupportTicket::getCategories();
                                        @endphp
                                        {{ $categories[$ticket->category] ?? $ticket->category }}
                                    </td>
                                    <td class="px-6 py-4 text-gray-800">{{ $ticket->updated_at->format('d/m/Y H:i') }}</td>
                                    <td class="px-6 py-4">
                                        <a href="{{ route('admin.support.show', $ticket->id) }}" class="flex items-center text-primary hover:text-primary-dark">
                                            <i class="mr-1 mdi mdi-eye"></i>
                                            <span>Visualizar</span>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                    {{ $resolvedTickets->links() }}
                </div>
            </div>
        @else
            <div class="p-8 text-center bg-white rounded-lg shadow ticket-card">
                <p class="text-gray-600">Não há tickets resolvidos no momento.</p>
            </div>
        @endif
    </div>

    <!-- Script para controlar as tabs - Código corrigido -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Obter todos os botões de tab
        const tabButtons = document.querySelectorAll('.tab-button');

        // Adicionar evento de clique para cada botão
        tabButtons.forEach(button => {
            button.addEventListener('click', function(event) {
                // Prevenir a navegação da página
                event.preventDefault();

                // Obter o ID da tab a ser mostrada
                const tabId = this.getAttribute('data-tab');

                // Chamar a função para mostrar a tab selecionada
                showTab(tabId);
            });
        });

        function showTab(tabId) {
            // Esconder todos os conteúdos das tabs
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.add('hidden');
            });

            // Mostrar o conteúdo da tab selecionada
            document.getElementById(tabId).classList.remove('hidden');

            // Resetar os estilos dos botões das tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('text-primary', 'border-primary');
                button.classList.add('text-gray-500', 'border-transparent');
            });

            // Adicionar o estilo ativo ao botão da tab selecionada
            document.querySelector(`.tab-button[data-tab="${tabId}"]`).classList.remove('text-gray-500', 'border-transparent');
            document.querySelector(`.tab-button[data-tab="${tabId}"]`).classList.add('text-primary', 'border-primary');
        }
    });
    </script>
</div>
@endsection
