<!-- Modal de Respostas Rápidas com Tailwind -->
<div id="quickResponseModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
        <!-- Overlay de fundo -->
        <div class="fixed inset-0 transition-opacity" aria-hidden="true">
            <div class="absolute inset-0 bg-black opacity-50"></div>
        </div>

        <!-- Centralizador do modal -->
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

        <!-- Modal em si -->
        <div class="inline-block overflow-hidden text-left align-bottom transition-all transform shadow-xl bg-zinc-800 rounded-xl sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
            <!-- Cabeçalho do modal -->
            <div class="flex items-center justify-between px-6 py-4 border-b border-zinc-700">
                <h3 class="text-lg font-medium text-white">Respostas Rápidas</h3>
                <button type="button" class="text-gray-400 close-modal hover:text-white">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>

            <!-- Conteúdo do modal -->
            <div class="px-6 py-4 overflow-y-auto max-h-96">
                <div class="space-y-2">
                    <button type="button" class="w-full px-4 py-3 text-left text-white transition-colors rounded quick-response-item bg-zinc-700 hover:bg-zinc-600" data-response="Obrigado por entrar em contato com o suporte. Estamos analisando sua solicitação e retornaremos em breve.">
                        Confirmação de recebimento
                    </button>

                    <button type="button" class="w-full px-4 py-3 text-left text-white transition-colors rounded quick-response-item bg-zinc-700 hover:bg-zinc-600" data-response="Seu problema foi resolvido. Por favor, tente acessar o serviço novamente e nos informe se o problema persistir.">
                        Confirmação de resolução
                    </button>

                    <button type="button" class="w-full px-4 py-3 text-left text-white transition-colors rounded quick-response-item bg-zinc-700 hover:bg-zinc-600" data-response="Estamos trabalhando para resolver seu problema. Nossa equipe técnica está analisando a situação e precisaremos de mais algum tempo para encontrar uma solução.">
                        Em análise técnica
                    </button>

                    <button type="button" class="w-full px-4 py-3 text-left text-white transition-colors rounded quick-response-item bg-zinc-700 hover:bg-zinc-600" data-response="Para melhor atendê-lo, precisamos de mais informações. Poderia por favor nos informar:
1. Qual dispositivo está utilizando?
2. Qual navegador/app está usando?
3. Você consegue enviar um print ou vídeo do problema?">
                        Solicitação de mais informações
                    </button>

                    <button type="button" class="w-full px-4 py-3 text-left text-white transition-colors rounded quick-response-item bg-zinc-700 hover:bg-zinc-600" data-response="Agradecemos por reportar este problema. Conseguimos reproduzir o erro e já estamos trabalhando em uma correção que será implementada em breve.">
                        Bug confirmado
                    </button>
                </div>
            </div>

            <!-- Rodapé do modal -->
            <div class="flex justify-end px-6 py-4 border-t border-zinc-700">
                <button type="button" class="px-4 py-2 text-white transition-colors rounded close-modal bg-zinc-600 hover:bg-zinc-500">
                    Fechar
                </button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Referências aos elementos
    const modal = document.getElementById('quickResponseModal');
    const openModalButton = document.querySelector('[data-open-modal]');
    const closeButtons = document.querySelectorAll('.close-modal');
    const quickResponseItems = document.querySelectorAll('.quick-response-item');

    // Função para abrir modal
    function openModal() {
        modal.classList.remove('hidden');
        document.body.style.overflow = 'hidden'; // Impede rolagem do body
    }

    // Função para fechar modal
    function closeModal() {
        modal.classList.add('hidden');
        document.body.style.overflow = ''; // Restaura rolagem do body
    }

    // Adiciona evento ao botão de abrir modal
    if (openModalButton) {
        openModalButton.addEventListener('click', openModal);
    }

    // Adiciona evento aos botões para fechar modal
    closeButtons.forEach(button => {
        button.addEventListener('click', closeModal);
    });

    // Fecha o modal ao clicar no overlay
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            closeModal();
        }
    });

    // Fecha o modal com tecla ESC
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && !modal.classList.contains('hidden')) {
            closeModal();
        }
    });

    // Adiciona evento de clique aos itens de resposta rápida
    quickResponseItems.forEach(item => {
        item.addEventListener('click', function() {
            const responseText = this.getAttribute('data-response');
            const adminResponseTextarea = document.getElementById('admin_response');

            // Insere a resposta no campo de texto
            if (adminResponseTextarea) {
                // Se já houver texto, adiciona uma quebra de linha antes
                if (adminResponseTextarea.value.trim() !== '') {
                    adminResponseTextarea.value += '\n\n' + responseText;
                } else {
                    adminResponseTextarea.value = responseText;
                }
            }

            // Fecha o modal
            closeModal();
        });
    });
});
</script>
