@extends('layouts.admin')

@section('content')
<div class="container px-4 py-20 mx-auto">
    <h1 class="mb-6 text-2xl font-bold">Status de Webhooks do SuitPay</h1>

    <div class="p-6 mb-8 bg-white rounded-lg shadow-md">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold">Informações Gerais</h2>
            <div class="flex space-x-2">
                <a href="{{ url('/suitpay/test-webhook') }}"
                   onclick="event.preventDefault(); document.getElementById('test-webhook-form').submit();"
                   class="px-4 py-2 text-white bg-blue-500 rounded hover:bg-blue-600">
                    Enviar Webhook de Teste
                </a>
                <form id="test-webhook-form" action="{{ url('/suitpay/test-webhook') }}" method="POST" style="display: none;">
                    @csrf
                </form>
                <a href="{{ url('/admin/suitpay/webhook-status') }}" class="px-4 py-2 text-white bg-gray-500 rounded hover:bg-gray-600">
                    Atualizar
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
            <div class="p-4 bg-gray-100 rounded-md">
                <h3 class="mb-2 font-medium">URL do Webhook</h3>
                <div class="flex items-center">
                    <input type="text" value="{{ $webhook_route }}" readonly class="w-full px-3 py-2 text-sm border rounded bg-gray-50">
                    <button onclick="copyToClipboard('{{ $webhook_route }}')" class="px-3 py-2 ml-2 bg-gray-200 rounded hover:bg-gray-300">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
                <p class="mt-2 text-sm text-gray-600">Esta URL deve ser configurada no painel da SuitPay.</p>
            </div>

            <div class="p-4 bg-gray-100 rounded-md">
                <h3 class="mb-2 font-medium">Webhooks Recebidos</h3>
                <div class="flex items-center justify-between">
                    <div>
                        <p><strong>Hoje:</strong> {{ $webhooks_today }}</p>
                        <p><strong>Último recebido:</strong> {{ $last_webhook ? $last_webhook['time'] : 'Nenhum' }}</p>
                    </div>
                    <div class="text-4xl font-bold {{ $webhooks_today > 0 ? 'text-green-500' : 'text-red-500' }}">
                        {{ $webhooks_today > 0 ? $webhooks_today : 0 }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if($last_webhook)
    <div class="p-6 mb-8 bg-white rounded-lg shadow-md">
        <h2 class="mb-4 text-xl font-semibold">Último Webhook</h2>
        <div class="p-4 bg-gray-100 rounded-md">
            <table class="w-full text-sm">
                <tr>
                    <td class="w-1/4 font-medium">Data/Hora:</td>
                    <td>{{ $last_webhook['time'] }}</td>
                </tr>
                <tr>
                    <td class="font-medium">IP de Origem:</td>
                    <td>{{ $last_webhook['ip'] }}</td>
                </tr>
                <tr>
                    <td class="font-medium">Arquivo:</td>
                    <td>{{ $last_webhook['file'] }}</td>
                </tr>
            </table>

            <h3 class="mt-4 mb-2 font-medium">Dados recebidos:</h3>
            <div class="p-3 overflow-auto rounded bg-gray-50 max-h-60">
                <pre class="text-xs">{{ json_encode($last_webhook['data'], JSON_PRETTY_PRINT) }}</pre>
            </div>
        </div>
    </div>
    @endif

    <div class="p-6 bg-white rounded-lg shadow-md">
        <h2 class="mb-4 text-xl font-semibold">Histórico (Últimos 30 dias)</h2>

        <div class="p-4 overflow-hidden bg-gray-100 rounded-md">
            <canvas id="webhookChart" height="100"></canvas>
        </div>

        <table class="w-full mt-6 text-sm">
            <thead>
                <tr class="bg-gray-200">
                    <th class="p-2 text-left">Data</th>
                    <th class="p-2 text-right">Webhooks</th>
                </tr>
            </thead>
            <tbody>
                @foreach($last_30_days as $date => $count)
                <tr class="border-b hover:bg-gray-50">
                    <td class="p-2">{{ $date }}</td>
                    <td class="p-2 text-right">{{ $count }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="p-4 mt-6 text-yellow-700 border-l-4 border-yellow-400 bg-yellow-50">
        <p class="font-medium">Nota de Diagnóstico:</p>
        <p class="mt-1">Os webhooks são armazenados em: <code>{{ $webhooks_directory }}</code></p>
        <p class="mt-1">Se não estiver recebendo webhooks, verifique:</p>
        <ul class="mt-1 ml-5 list-disc">
            <li>Se a URL do webhook está configurada corretamente na SuitPay</li>
            <li>Se o servidor está acessível externamente (sem firewall bloqueando)</li>
            <li>Se as rotas foram registradas corretamente no Laravel</li>
            <li>Se o middleware CSRF está desabilitado para essa rota</li>
        </ul>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    function copyToClipboard(text) {
        const input = document.createElement('input');
        input.style.position = 'fixed';
        input.style.opacity = 0;
        input.value = text;
        document.body.appendChild(input);
        input.select();
        document.execCommand('copy');
        document.body.removeChild(input);

        // Mostrar um alerta ou feedback
        alert('URL copiada para a área de transferência!');
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Carregando dados para o gráfico
        const data = @json($last_30_days);
        const labels = Object.keys(data);
        const values = Object.values(data);

        const ctx = document.getElementById('webhookChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Webhooks Recebidos',
                    data: values,
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0
                        }
                    }
                }
            }
        });
    });
</script>
@endsection
