@extends('admin.layout')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Criar Novo Plano</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.plans') }}">Planos</a></li>
                        <li class="breadcrumb-item active">Novo Plano</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Detalhes do Plano</h3>
                        </div>
                        <div class="card-body">
                            <form id="createPlanForm" action="{{ route('admin.plans.store') }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="name">Nome do Plano</label>
                                            <input type="text" class="form-control" id="name" name="name" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="slug">Slug (opcional)</label>
                                            <input type="text" class="form-control" id="slug" name="slug">
                                            <small class="form-text text-muted">Se deixado em branco, será gerado automaticamente</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="price">Preço (R$)</label>
                                            <input type="number" class="form-control" id="price" name="price" step="0.01" min="0" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="device_limit">Limite de Dispositivos</label>
                                            <input type="number" class="form-control" id="device_limit" name="device_limit" min="1" value="1" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="priority">Prioridade</label>
                                            <input type="number" class="form-control" id="priority" name="priority" min="0" value="0">
                                            <small class="form-text text-muted">Maior valor = maior prioridade</small>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="color">Cor do Plano</label>
                                            <input type="color" class="form-control" id="color" name="color" value="#3498db">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check mt-4">
                                            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" checked>
                                            <label class="form-check-label" for="is_active">Plano Ativo</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="description">Descrição</label>
                                    <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                                </div>

                                <div class="form-group">
                                    <label>Recursos do Plano</label>
                                    <div class="feature-inputs">
                                        <div class="input-group mb-2">
                                            <input type="text" class="form-control" name="features[]" placeholder="Ex: Acesso a todo conteúdo">
                                            <div class="input-group-append">
                                                <button class="btn btn-outline-danger remove-feature" type="button"><i class="fas fa-minus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-primary mt-2" id="add-feature-btn">
                                        <i class="fas fa-plus"></i> Adicionar Recurso
                                    </button>
                                </div>

                                <div class="form-group mt-4">
                                    <button type="submit" class="btn btn-primary">Salvar Plano</button>
                                    <a href="{{ route('admin.plans') }}" class="btn btn-secondary">Cancelar</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Converter nome para slug automaticamente
        $('#name').on('input', function() {
            if ($('#slug').val() === '') {
                const name = $(this).val();
                const slug = name
                    .toLowerCase()
                    .replace(/[^\w\s-]/g, '')
                    .replace(/[\s_-]+/g, '-')
                    .replace(/^-+|-+$/g, '');

                $('#slug').val(slug);
            }
        });

        // Adicionar recurso
        $('#add-feature-btn').click(function() {
            $('.feature-inputs').append(`
                <div class="input-group mb-2">
                    <input type="text" class="form-control" name="features[]" placeholder="Ex: Acesso a todo conteúdo">
                    <div class="input-group-append">
                        <button class="btn btn-outline-danger remove-feature" type="button"><i class="fas fa-minus"></i></button>
                    </div>
                </div>
            `);
        });

        // Remover recurso
        $(document).on('click', '.remove-feature', function() {
            $(this).closest('.input-group').remove();
        });
    });
</script>
@endsection
