@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Mapeamento de EPG para Canais</h3>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="input-group">
                                <input type="text" id="searchChannel" class="form-control" placeholder="Buscar canal na EPG...">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" id="searchBtn" type="button">Buscar</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div id="searchResults" class="d-none">
                                <h4>Resultados da Busca</h4>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Nome do Canal</th>
                                                <th>ID</th>
                                                <th>Ação</th>
                                            </tr>
                                        </thead>
                                        <tbody id="resultsBody"></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <h4>Canais Disponíveis</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Canal</th>
                                    <th>ID EPG Atual</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($channels as $channel)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img src="{{ $channel->poster_path }}" alt="{{ $channel->name }}" style="width: 40px; height: 40px; object-fit: cover;" class="mr-2">
                                            <span>{{ $channel->name }}</span>
                                        </div>
                                    </td>
                                    <td>
                                        @if($channel->videos->isNotEmpty() && $channel->videos->first()->epg_channel_id)
                                            <span class="badge badge-success">{{ $channel->videos->first()->epg_channel_id }}</span>
                                        @else
                                            <span class="badge badge-secondary">Não definido</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-info search-for-channel"
                                                data-channel-name="{{ $channel->name }}"
                                                data-video-id="{{ $channel->videos->isNotEmpty() ? $channel->videos->first()->id : '' }}">
                                            Buscar EPG
                                        </button>

                                        @if($channel->videos->isNotEmpty() && $channel->videos->first()->epg_channel_id)
                                            <button class="btn btn-sm btn-danger remove-epg"
                                                    data-video-id="{{ $channel->videos->first()->id }}">
                                                Remover EPG
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Função para buscar canais na API EPG
        function searchChannels(query) {
            $('#searchResults').addClass('d-none');
            $('#resultsBody').html('<tr><td colspan="3" class="text-center">Carregando...</td></tr>');

            $.ajax({
                url: '{{ route("epg.search") }}',
                data: { query: query },
                method: 'GET',
                success: function(response) {
                    $('#searchResults').removeClass('d-none');
                    $('#resultsBody').empty();

                    if (response.channels && response.channels.length) {
                        response.channels.forEach(function(channel) {
                            var row = '<tr>' +
                                '<td>' + channel.name + '</td>' +
                                '<td>' + channel.id + '</td>' +
                                '<td>' +
                                '<button class="btn btn-sm btn-success select-channel" ' +
                                'data-channel-id="' + channel.id + '" ' +
                                'data-channel-name="' + channel.name + '">Selecionar</button>' +
                                '</td>' +
                                '</tr>';
                            $('#resultsBody').append(row);
                        });
                    } else {
                        $('#resultsBody').html('<tr><td colspan="3" class="text-center">Nenhum resultado encontrado</td></tr>');
                    }
                },
                error: function(xhr) {
                    $('#searchResults').removeClass('d-none');
                    $('#resultsBody').html('<tr><td colspan="3" class="text-center text-danger">Erro ao buscar canais: ' +
                        (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido') + '</td></tr>');
                }
            });
        }

        // Botão de busca global
        $('#searchBtn').click(function() {
            var query = $('#searchChannel').val();
            if (query) {
                searchChannels(query);
            }
        });

        // Enter no campo de busca
        $('#searchChannel').keypress(function(e) {
            if (e.which === 13) {
                $('#searchBtn').click();
            }
        });

        // Busca específica para um canal
        $(document).on('click', '.search-for-channel', function() {
            var channelName = $(this).data('channel-name');
            $('#searchChannel').val(channelName);
            $('#searchBtn').click();

            // Armazena o ID do vídeo no localStorage para uso posterior
            var videoId = $(this).data('video-id');
            if (videoId) {
                localStorage.setItem('currentVideoId', videoId);
            }
        });

        // Selecionar um canal da busca
        $(document).on('click', '.select-channel', function() {
            var channelId = $(this).data('channel-id');
            var videoId = localStorage.getItem('currentVideoId');

            if (!videoId) {
                alert('Erro: ID do vídeo não encontrado. Tente novamente.');
                return;
            }

            $.ajax({
                url: '{{ url("epg/channel") }}/' + videoId,
                method: 'POST',
                data: {
                    epg_channel_id: channelId,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    alert('ID de EPG atualizado com sucesso!');
                    location.reload();
                },
                error: function(xhr) {
                    alert('Erro ao atualizar ID de EPG: ' +
                        (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido'));
                }
            });
        });

        // Remover EPG de um canal
        $(document).on('click', '.remove-epg', function() {
            if (confirm('Tem certeza que deseja remover o mapeamento EPG deste canal?')) {
                var videoId = $(this).data('video-id');

                $.ajax({
                    url: '{{ url("epg/channel") }}/' + videoId,
                    method: 'POST',
                    data: {
                        epg_channel_id: null,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        alert('Mapeamento EPG removido com sucesso!');
                        location.reload();
                    },
                    error: function(xhr) {
                        alert('Erro ao remover mapeamento EPG: ' +
                            (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido'));
                    }
                });
            }
        });
    });
</script>
@endsection
