<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - {{$settings->app_name}}</title>
    <link rel="icon" href="{{ route('minilogo') }}" type="image/x-icon">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="{{ asset('js/tema.js') }}" defer></script>
</head>
<body class="text-white bg-zinc-900">
    <div class="flex items-center justify-center min-h-screen">
        <div class="w-full max-w-md p-8 space-y-6 rounded-lg shadow-xl bg-zinc-800">
            <div class="text-center">
                <img src="{{ route('minilogo') }}" alt="{{$settings->app_name}} Logo" class="h-24 mx-auto mb-4">
                <h1 class="text-xl font-bold text-primary">Admin Login</h1>
            </div>

            @if($errors->any())
                <div class="p-4 text-red-400 border border-red-500 rounded-md bg-red-500/10">
                    @foreach($errors->all() as $error)
                        <p>{{ $error }}</p>
                    @endforeach
                </div>
            @endif

            <form method="POST" action="{{ route('admin.login') }}" class="space-y-6">
                @csrf

                <div class="space-y-2">
                    <label for="email" class="text-sm font-medium text-zinc-300">Email</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-zinc-500">
                            <i class="fas fa-envelope"></i>
                        </span>
                        <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus
                               class="w-full px-4 py-2 pl-10 rounded-md bg-zinc-700 focus:outline-none focus:ring-2 focus:ring-primary">
                    </div>
                </div>

                <div class="space-y-2">
                    <label for="password" class="text-sm font-medium text-zinc-300">Senha</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-zinc-500">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input id="password" type="password" name="password" required
                               class="w-full px-4 py-2 pl-10 rounded-md bg-zinc-700 focus:outline-none focus:ring-2 focus:ring-primary">
                    </div>
                </div>

                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input id="remember" name="remember" type="checkbox"
                               class="w-4 h-4 rounded border-zinc-600 text-primary focus:ring-primary">
                        <label for="remember" class="block ml-2 text-sm text-zinc-400">Lembrar-me</label>
                    </div>
                </div>

                <div>
                    <button type="submit" class="w-full px-4 py-3 font-semibold text-black transition duration-300 rounded-md bg-primary hover:scale-105">
                        Entrar
                    </button>
                </div>
            </form>

            <div class="mt-4 text-sm text-center text-zinc-400">
                <p>Painel Administrativo {{$settings->app_name}}</p>
                <p class="mt-2">© {{ date('Y') }} Todos os direitos reservados</p>
            </div>
        </div>
    </div>
</body>
</html>
