/**
 * Gestão de componentes da página de séries
 */
const SerieComponents = {
    // Inicializa os componentes
    init() {
        this.registerDebugInfo();
        this.initEpisodeList();
        this.initCastList();
    },

    // Registra informações de debug no console
    registerDebugInfo() {
        console.log('[SerieComponents] Inicializando componentes');

        // Verificar se os elementos estão presentes
        if (document.querySelector('.cast-list')) {
            console.log('[SerieComponents] Cast list encontrada');
        } else {
            console.warn('[SerieComponents] Cast list não encontrada');
        }

        if (document.querySelector('.episode-list')) {
            console.log('[SerieComponents] Episode list encontrada');
        } else {
            console.warn('[SerieComponents] Episode list não encontrada');
        }
    },

    // Inicializa a lista de episódios
    initEpisodeList() {
        const seasonButtons = document.querySelectorAll('.season-button');
        if (!seasonButtons.length) {
            console.warn('[SerieComponents] Botões de temporada não encontrados');
            return;
        }

        seasonButtons.forEach(button => {
            button.addEventListener('click', function() {
                const seasonNumber = this.dataset.season;

                // Atualiza classes de botões
                seasonButtons.forEach(btn => {
                    btn.classList.remove('bg-primary', 'text-black');
                    btn.classList.add('bg-zinc-800', 'text-white', 'hover:bg-zinc-700');
                });

                this.classList.remove('bg-zinc-800', 'text-white', 'hover:bg-zinc-700');
                this.classList.add('bg-primary', 'text-black');

                // Atualiza visibilidade das temporadas
                document.querySelectorAll('.season-episodes').forEach(season => {
                    season.classList.add('hidden');
                });

                const targetSeason = document.getElementById(`season_${seasonNumber}`);
                if (targetSeason) {
                    targetSeason.classList.remove('hidden');
                } else {
                    console.error(`[SerieComponents] Temporada ${seasonNumber} não encontrada`);
                }

                // Integração com SerieApp
                if (typeof SerieApp !== 'undefined') {
                    SerieApp.state.currentSeason = seasonNumber;
                }
            });
        });
    },

    // Inicializa a lista de elenco
    initCastList() {
        const castList = document.querySelector('.cast-list');
        if (!castList) return;

        // Implementar qualquer funcionalidade específica da lista de elenco aqui
        // Por exemplo: lazy loading de imagens, tooltips, etc.
    }
};

// Inicializa os componentes quando o DOM estiver pronto
document.addEventListener('DOMContentLoaded', () => SerieComponents.init());
