/**
 * Script para gerenciar o mapeamento de EPG no painel administrativo
 */
(function() {
    // Função para buscar canais na API EPG
    function searchChannels(query) {
        $('#searchResults').addClass('d-none');
        $('#resultsBody').html('<tr><td colspan="3" class="text-center">Carregando...</td></tr>');

        $.ajax({
            url: '/epg/search',
            data: { query: query },
            method: 'GET',
            success: function(response) {
                $('#searchResults').removeClass('d-none');
                $('#resultsBody').empty();

                if (response.channels && response.channels.length) {
                    response.channels.forEach(function(channel) {
                        var row = '<tr>' +
                            '<td>' + channel.name + '</td>' +
                            '<td>' + channel.id + '</td>' +
                            '<td>' +
                            '<button class="btn btn-sm btn-success select-channel" ' +
                            'data-channel-id="' + channel.id + '" ' +
                            'data-channel-name="' + channel.name + '">Selecionar</button>' +
                            '</td>' +
                            '</tr>';
                        $('#resultsBody').append(row);
                    });
                } else {
                    $('#resultsBody').html('<tr><td colspan="3" class="text-center">Nenhum resultado encontrado</td></tr>');
                }
            },
            error: function(xhr) {
                $('#searchResults').removeClass('d-none');
                $('#resultsBody').html('<tr><td colspan="3" class="text-center text-danger">Erro ao buscar canais: ' +
                    (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido') + '</td></tr>');
            }
        });
    }

    // Configurar manipuladores de eventos quando o documento estiver pronto
    $(document).ready(function() {
        // Botão de busca global
        $('#searchBtn').click(function() {
            var query = $('#searchChannel').val();
            if (query) {
                searchChannels(query);
            }
        });

        // Enter no campo de busca
        $('#searchChannel').keypress(function(e) {
            if (e.which === 13) {
                $('#searchBtn').click();
            }
        });

        // Busca específica para um canal
        $(document).on('click', '.search-for-channel', function() {
            var channelName = $(this).data('channel-name');
            $('#searchChannel').val(channelName);
            $('#searchBtn').click();

            // Armazena o ID do vídeo no localStorage para uso posterior
            var videoId = $(this).data('video-id');
            if (videoId) {
                localStorage.setItem('currentVideoId', videoId);
            }
        });

        // Selecionar um canal da busca
        $(document).on('click', '.select-channel', function() {
            var channelId = $(this).data('channel-id');
            var videoId = localStorage.getItem('currentVideoId');

            if (!videoId) {
                alert('Erro: ID do vídeo não encontrado. Tente novamente.');
                return;
            }

            $.ajax({
                url: '/epg/channel/' + videoId,
                method: 'POST',
                data: {
                    epg_channel_id: channelId,
                    _token: $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    alert('ID de EPG atualizado com sucesso!');
                    location.reload();
                },
                error: function(xhr) {
                    alert('Erro ao atualizar ID de EPG: ' +
                        (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido'));
                }
            });
        });

        // Remover EPG de um canal
        $(document).on('click', '.remove-epg', function() {
            if (confirm('Tem certeza que deseja remover o mapeamento EPG deste canal?')) {
                var videoId = $(this).data('video-id');

                $.ajax({
                    url: '/epg/channel/' + videoId,
                    method: 'POST',
                    data: {
                        epg_channel_id: null,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        alert('Mapeamento EPG removido com sucesso!');
                        location.reload();
                    },
                    error: function(xhr) {
                        alert('Erro ao remover mapeamento EPG: ' +
                            (xhr.responseJSON ? xhr.responseJSON.error : 'Erro desconhecido'));
                    }
                });
            }
        });
    });
})();
