<?php

date_default_timezone_set('America/Sao_Paulo');
require __DIR__ . '/../vendor/autoload.php';

use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Firebase\JWT\ExpiredException;
use Firebase\JWT\SignatureInvalidException;
use Firebase\JWT\BeforeValidException;
use Exception;
use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

// Inicializa o Logger
$log = new Logger('authLogger');
$log->pushHandler(new StreamHandler(__DIR__ . '/auth.log', Logger::WARNING));

// Define a chave secreta
$key = 'iCUjW0hsKrkJXWiUMzASowBPafh65dBAhqYzEFcLcedIQRtZ3IvaBedZupvlZoeb';

// Verifica o método da requisição
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo "Método não permitido";
    exit;
}

// Função para enviar resposta
function sendResponse($code, $message) {
    global $log;
    http_response_code($code);
    header("Content-Type: application/json");
    echo json_encode(["message" => $message]);
    $log->warning($message);
    exit;
}

// Extrai e valida o token
$token = $_GET['token'] ?? '';
if (empty($token)) {
    sendResponse(400, "Token não fornecido");
}

try {
    $decoded = JWT::decode($token, new Key($key, 'HS256'));

    // Token válido, envia resposta de sucesso
    sendResponse(200, "Autenticação bem-sucedida");
} catch (ExpiredException $ee) {
    sendResponse(403, "Token expirado");
} catch (SignatureInvalidException $sie) {
    sendResponse(403, "Assinatura do token inválida");
} catch (BeforeValidException $bve) {
    sendResponse(403, "Token ainda não é válido");
} catch (Exception $e) {
    // Captura qualquer outra exceção desconhecida
    $log->error('Erro inesperado: ' . $e->getMessage());
    sendResponse(500, "Erro interno do servidor");
}