<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CleanupFavoritesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Remover entradas duplicadas (manter apenas uma)
        $duplicates = DB::table('favorites')
            ->select('profile_id', 'favoriteable_id', 'favoriteable_type', DB::raw('COUNT(*) as count'))
            ->groupBy('profile_id', 'favoriteable_id', 'favoriteable_type')
            ->having('count', '>', 1)
            ->get();

        $removed = 0;

        foreach ($duplicates as $duplicate) {
            $entries = DB::table('favorites')
                ->where('profile_id', $duplicate->profile_id)
                ->where('favoriteable_id', $duplicate->favoriteable_id)
                ->where('favoriteable_type', $duplicate->favoriteable_type)
                ->orderBy('id', 'asc')
                ->get();

            if ($entries->count() > 1) {
                // Manter o primeiro, excluir os outros
                $idsToRemove = $entries->slice(1)->pluck('id')->toArray();
                DB::table('favorites')->whereIn('id', $idsToRemove)->delete();
                $removed += count($idsToRemove);
            }
        }

        $this->command->info("Removidas {$removed} entradas duplicadas da tabela favorites");
    }
}
