<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Atualizar tabela de planos para incluir limite de dispositivos e outros campos
        if (Schema::hasTable('plans')) {
            Schema::table('plans', function (Blueprint $table) {
                if (!Schema::hasColumn('plans', 'device_limit')) {
                    $table->integer('device_limit')->default(1)->after('price');
                }
                if (!Schema::hasColumn('plans', 'features')) {
                    $table->json('features')->nullable()->after('device_limit');
                }
                if (!Schema::hasColumn('plans', 'is_active')) {
                    $table->boolean('is_active')->default(true)->after('features');
                }
                if (!Schema::hasColumn('plans', 'priority')) {
                    $table->integer('priority')->default(0)->after('is_active');
                }
                if (!Schema::hasColumn('plans', 'color')) {
                    $table->string('color')->default('#3498db')->after('priority');
                }
            });
        }

        // Garantir que a tabela de dispositivos tenha todos os campos necessários
        if (Schema::hasTable('devices')) {
            Schema::table('devices', function (Blueprint $table) {
                if (!Schema::hasColumn('devices', 'name')) {
                    $table->string('name')->nullable();
                }
                if (!Schema::hasColumn('devices', 'device_type')) {
                    $table->string('device_type')->nullable();
                }
                if (!Schema::hasColumn('devices', 'ip_address')) {
                    $table->string('ip_address')->nullable();
                }
                if (!Schema::hasColumn('devices', 'user_agent')) {
                    $table->text('user_agent')->nullable();
                }
                if (!Schema::hasColumn('devices', 'last_active')) {
                    $table->timestamp('last_active')->nullable();
                }
                if (!Schema::hasColumn('devices', 'is_current')) {
                    $table->boolean('is_current')->default(false);
                }
                if (!Schema::hasColumn('devices', 'serial_number')) {
                    $table->string('serial_number')->nullable();
                }
                // Adição de índice para melhorar a performance
                if (!Schema::hasIndex('devices', 'devices_user_id_is_current_index')) {
                    $table->index(['user_id', 'is_current']);
                }
            });
        }

        // Atualizar tabela de assinaturas para incluir limite de dispositivos
        if (Schema::hasTable('subscriptions')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                if (!Schema::hasColumn('subscriptions', 'device_limit')) {
                    $table->integer('device_limit')->nullable()->after('ends_at');
                }
            });
        }

        // Atualizar tabela de usuários para incluir limite de dispositivos específico
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (!Schema::hasColumn('users', 'device_limit')) {
                    $table->integer('device_limit')->nullable()->after('expired_in');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Não é necessário reverter essa migração
    }
}
;
