<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            // Removendo qualquer chave estrangeira se existir
            $table->dropForeign(['movie_id']);  // Adapte o nome da foreign key conforme necessário

            // Renomeando a coluna movie_id para item_id
            $table->renameColumn('movie_id', 'item_id');
        });
    }

    public function down()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            // Restaurando o nome original da coluna
            $table->renameColumn('item_id', 'movie_id');

            // Adicionando novamente a chave estrangeira, se necessário
            $table->foreign('movie_id')->references('id')->on('movies');  // Ajuste conforme a tabela original
        });
    }
};
