<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Verificar se a tabela existe
        if (Schema::hasTable('devices')) {
            Schema::table('devices', function (Blueprint $table) {
                // Verificar e adicionar colunas necessárias
                if (!Schema::hasColumn('devices', 'device_type')) {
                    $table->string('device_type')->nullable()->after('name');
                }

                if (!Schema::hasColumn('devices', 'ip_address')) {
                    $table->string('ip_address')->nullable()->after('device_type');
                }

                if (!Schema::hasColumn('devices', 'user_agent')) {
                    $table->text('user_agent')->nullable()->after('ip_address');
                }

                if (!Schema::hasColumn('devices', 'last_active')) {
                    $table->timestamp('last_active')->nullable()->after('user_agent');
                }

                if (!Schema::hasColumn('devices', 'is_current')) {
                    $table->boolean('is_current')->default(false)->after('last_active');
                }

                if (!Schema::hasColumn('devices', 'serial_number') && !Schema::hasColumn('devices', 'name')) {
                    $table->string('serial_number')->nullable()->after('user_id');
                }
            });
        }
    }

    public function down(): void
    {
        // Remover as colunas adicionadas
        if (Schema::hasTable('devices')) {
            Schema::table('devices', function (Blueprint $table) {
                $columns = [
                    'device_type', 'ip_address', 'user_agent',
                    'last_active', 'is_current', 'serial_number'
                ];

                foreach ($columns as $column) {
                    if (Schema::hasColumn('devices', $column)) {
                        $table->dropColumn($column);
                    }
                }
            });
        }
    }
};
