<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            if (!Schema::hasColumn('continue_watching', 'profile_id')) {
                $table->unsignedBigInteger('profile_id')->nullable()->after('id');
                $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('cascade');
            }

            if (!Schema::hasColumn('continue_watching', 'user_id')) {
                $table->unsignedBigInteger('user_id')->nullable()->after('profile_id');
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            $table->dropForeign(['profile_id']);
            $table->dropColumn('profile_id');

            $table->dropForeign(['user_id']);
            $table->dropColumn('user_id');
        });
    }
}
;
