<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            // Adiciona os campos novos se não existirem
            if (!Schema::hasColumn('continue_watching', 'position')) {
                $table->float('position')->nullable()->default(0);
            }

            if (!Schema::hasColumn('continue_watching', 'duration')) {
                $table->float('duration')->nullable()->default(0);
            }

            if (!Schema::hasColumn('continue_watching', 'episode_id')) {
                $table->unsignedBigInteger('episode_id')->nullable();
            }

            if (!Schema::hasColumn('continue_watching', 'season_number')) {
                $table->integer('season_number')->nullable();
            }

            if (!Schema::hasColumn('continue_watching', 'episode_number')) {
                $table->integer('episode_number')->nullable();
            }

            // Garante que a tabela tenha timestamps
            if (!Schema::hasColumn('continue_watching', 'created_at')) {
                $table->timestamps();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('continue_watching', function (Blueprint $table) {
            $table->dropColumn(['position', 'duration', 'episode_id', 'season_number', 'episode_number']);
        });
    }
}
;
