<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Tabela para favoritos de filmes
        Schema::create('profile_movie_favorites', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('profile_id');
            $table->unsignedBigInteger('movie_id');
            $table->timestamps();

            // Índices e chaves estrangeiras
            $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('cascade');
            $table->foreign('movie_id')->references('id')->on('movies')->onDelete('cascade');

            // Garante que não haja duplicatas
            $table->unique(['profile_id', 'movie_id']);
        });

        // Tabela para favoritos de séries
        Schema::create('profile_serie_favorites', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('profile_id');
            $table->unsignedBigInteger('serie_id');
            $table->timestamps();

            // Índices e chaves estrangeiras
            $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('cascade');
            $table->foreign('serie_id')->references('id')->on('series')->onDelete('cascade');

            // Garante que não haja duplicatas
            $table->unique(['profile_id', 'serie_id']);
        });

        // Tabela para favoritos de animes
        Schema::create('profile_anime_favorites', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('profile_id');
            $table->unsignedBigInteger('anime_id');
            $table->timestamps();

            // Índices e chaves estrangeiras
            $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('cascade');
            $table->foreign('anime_id')->references('id')->on('animes')->onDelete('cascade');

            // Garante que não haja duplicatas
            $table->unique(['profile_id', 'anime_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('profile_movie_favorites');
        Schema::dropIfExists('profile_serie_favorites');
        Schema::dropIfExists('profile_anime_favorites');
    }
}
;
