<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Adicionar campo device_limit à tabela de usuários
        // para permitir sobrescrita de limite
        if (Schema::hasTable('users') && !Schema::hasColumn('users', 'device_limit')) {
            Schema::table('users', function (Blueprint $table) {
                $table->integer('device_limit')->nullable()
                    ->comment('Limite de dispositivos personalizado para este usuário');
            });
        }

        // Também vamos verificar o campo device_limit nas tabelas plan e subscriptions
        if (Schema::hasTable('plans') && !Schema::hasColumn('plans', 'device_limit')) {
            Schema::table('plans', function (Blueprint $table) {
                $table->integer('device_limit')->default(1)
                    ->comment('Número máximo de dispositivos permitidos no plano');
            });
        }

        if (Schema::hasTable('subscriptions') && !Schema::hasColumn('subscriptions', 'device_limit')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                $table->integer('device_limit')->nullable()
                    ->comment('Número máximo de dispositivos personalizado para esta assinatura');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('users') && Schema::hasColumn('users', 'device_limit')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('device_limit');
            });
        }

        if (Schema::hasTable('plans') && Schema::hasColumn('plans', 'device_limit')) {
            Schema::table('plans', function (Blueprint $table) {
                $table->dropColumn('device_limit');
            });
        }

        if (Schema::hasTable('subscriptions') && Schema::hasColumn('subscriptions', 'device_limit')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                $table->dropColumn('device_limit');
            });
        }
    }
}
;
