<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Verificar se a tabela não existe antes de tentar criá-la
        if (!Schema::hasTable('devices')) {
            Schema::create('devices', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id');
                $table->string('name')->nullable();
                $table->string('device_type')->nullable();
                $table->string('serial_number')->nullable();
                $table->string('ip_address')->nullable();
                $table->text('user_agent')->nullable();
                $table->timestamp('last_active')->nullable();
                $table->boolean('is_current')->default(false);
                $table->timestamps();

                $table->foreign('user_id')
                    ->references('id')
                    ->on('users')
                    ->onDelete('cascade');
            });
        } else {
            // Se a tabela já existe, adicionamos as colunas que podem estar faltando
            Schema::table('devices', function (Blueprint $table) {
                if (!Schema::hasColumn('devices', 'device_type')) {
                    $table->string('device_type')->nullable();
                }
                if (!Schema::hasColumn('devices', 'ip_address')) {
                    $table->string('ip_address')->nullable();
                }
                if (!Schema::hasColumn('devices', 'user_agent')) {
                    $table->text('user_agent')->nullable();
                }
                if (!Schema::hasColumn('devices', 'last_active')) {
                    $table->timestamp('last_active')->nullable();
                }
                if (!Schema::hasColumn('devices', 'is_current')) {
                    $table->boolean('is_current')->default(false);
                }
                if (!Schema::hasColumn('devices', 'serial_number')) {
                    $table->string('serial_number')->nullable();
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('devices');
    }
}
;
