<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Verificar se a tabela existe antes de tentar alterá-la
        if (Schema::hasTable('subscriptions')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                // Adicionar campos se eles não existirem
                if (!Schema::hasColumn('subscriptions', 'device_limit')) {
                    $table->integer('device_limit')->default(1)
                        ->comment('Número máximo de dispositivos permitidos simultaneamente');
                }
            });
        }

        // Verificar se a tabela de planos existe e adicionar a coluna device_limit
        if (Schema::hasTable('plans')) {
            Schema::table('plans', function (Blueprint $table) {
                if (!Schema::hasColumn('plans', 'device_limit')) {
                    $table->integer('device_limit')->default(1)
                        ->comment('Número máximo de dispositivos permitidos no plano');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Como são colunas adicionais, ao reverter não deletamos a tabela inteira
        if (Schema::hasTable('subscriptions')) {
            Schema::table('subscriptions', function (Blueprint $table) {
                if (Schema::hasColumn('subscriptions', 'device_limit')) {
                    $table->dropColumn('device_limit');
                }
            });
        }

        if (Schema::hasTable('plans')) {
            Schema::table('plans', function (Blueprint $table) {
                if (Schema::hasColumn('plans', 'device_limit')) {
                    $table->dropColumn('device_limit');
                }
            });
        }
    }
}
;
