<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('continue_watching')) {
            Schema::create('continue_watching', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('profile_id');
                $table->string('item_id');
                $table->string('type'); // 'movie', 'serie', 'anime'
                $table->timestamp('updated_at')->nullable();

                $table->foreign('profile_id')->references('id')->on('profiles')->onDelete('cascade');
                $table->index(['profile_id', 'type']);
                $table->unique(['profile_id', 'item_id', 'type']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('continue_watching');
    }
}
;
