<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Primeiro vamos remover a chave primária existente
        Schema::table('favorites', function (Blueprint $table) {
            // Remover a chave primária existente
            $table->dropPrimary();
        });

        // Agora definimos uma nova chave primária com os três campos
        Schema::table('favorites', function (Blueprint $table) {
            // Criar uma ID normal como chave primária
            $table->id()->first();

            // Criar um índice único para evitar duplicatas
            $table->unique(['profile_id', 'favoriteable_id', 'favoriteable_type'], 'favorite_unique_constraint');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('favorites', function (Blueprint $table) {
            // Remover o índice único
            $table->dropUnique('favorite_unique_constraint');

            // Remover a coluna ID
            $table->dropColumn('id');

            // Restaurar a chave primária anterior
            $table->primary(['profile_id', 'favoriteable_id', 'favoriteable_type']);
        });
    }
}
;
