<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<head>
    
    
    <title>{{$filme->title}}</title>
    
    
    
    <link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="/css/web.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
</head>

@php

use Carbon\Carbon

@endphp
<body>

    @include('layouts._partials.header')
    <section class="backdrop" style="background-image: linear-gradient(to right, rgb(0 0 0 / 80%), transparent), linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent),
                  url('{{$filme->backdrop_path}}');
    background-size: cover;
    background-position: center center;">
        
        
        <div class="main">
            
            <div class="poster-m">
                <aside>
                    <img src="{{ $filme->poster_path }}" alt="{{ $filme->title }}">
                </aside>
                
                <div>
                    <div class="titulo">
                        <h1>{{ $filme->title }}</h1>
                    </div>

                    <div class="genres">
                        <div class="imdb">
                            <p>
                                <i class="fas fa-star"></i> {{ number_format($filme->vote_average, 1) }}
                            </p>
                        </div>
                        <ul>
                            @foreach ($filme->genres->take(3) as $genre)
                                <li><strong>{{ $genre->name }}</strong></li>
                            @endforeach
                        </ul>

                    </div>

                    <div class="sinopse">
                        <p>{{ $filme->overview }}</p>
                    </div>

                    <div class="informacoes">
                        <li>Ano: <strong>{{ Carbon::createFromFormat('Y-m-d', $filme->release_date)->format('Y') }}</strong></li>
                    </div>

                    <div class="duration">
                        <li>Duração: <strong>{{ $horas }}h {{ $minutos }} min</strong></li>
                    </div>

                    <div id="data-cast">
                        <span>Elenco:</span>
                        <ul>
                            @foreach ($filme->casters->take(3) as $index => $caster)
                                <li><strong>{{ $caster->name }}</strong>@if ($index < 2) , @endif</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            @php
                // Obter o usuário autenticado
                $user = auth()->user();

                // Verificar se o usuário está logado e se é premium
                $premiun = ($user && $user->premiun === 0) ? 1 : 0;
            @endphp

            @if ($premiun === 0)
                <div class="container">
                    <div class="player-left">
                        <!-- Aqui continua o restante do código relacionado ao player -->
                    </div>
                    <div class="player-options">
                        @php
                            $contador = 1;
                        @endphp
                        @foreach ($videos as $video)
                            <div class="option" data-link="{{ $video->link }}" data-host="{{ $video->supported_hosts }}">
                                Servidor {{ $contador }}
                            </div>
                            @php
                                $contador++;
                            @endphp
                        @endforeach
                    </div>
                </div>
            @else
                <!-- Mostra o banner HTML com o botão "assine agora" para usuários não premium -->
                <div class="banner">
                    <p>Assine agora para acessar o conteúdo premium!</p>
                    <button>Assine agora</button>
                </div>
            @endif


            
                <section class="related-movies-slider">
                    <div class="prev-next">
                        <h2>Filmes Relacionados</h2>
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    </div>
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        @foreach ($filmesRelacionados as $relatedMovie)
                            <div class="swiper-slide">
                                <a href="{{ route('filme.detail', ['id' => $relatedMovie->id]) }}">
                                    <img src="{{ $relatedMovie->poster_path }}" alt="{{ $relatedMovie->title }}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
        </div>


    </section>

    <script>
        // Script para controlar os players
        document.addEventListener('DOMContentLoaded', function () {
            const playerLeftContainer = document.querySelector('.player-left');
            const playerOptions = document.querySelectorAll('.option');

            // Função para carregar o player com o vídeo especificado
            function loadPlayer(link, host) {
                // Se o host for igual a 1, carregue o vídeo como iframe
                if (host === 1) {
                    const iframe = document.createElement('iframe');
                    iframe.setAttribute('src', link);
                    iframe.setAttribute('allowfullscreen', '');
                    playerLeftContainer.innerHTML = ''; // Limpa o conteúdo anterior
                    playerLeftContainer.appendChild(iframe);
                } else {
                    // Caso contrário, use o player Plyr para carregar o vídeo
                    const video = document.createElement('video');
                    const source = document.createElement('source');
                    video.appendChild(source);
                    source.setAttribute('src', link);
                    source.setAttribute('type', 'video/mp4');
                    playerLeftContainer.innerHTML = ''; // Limpa o conteúdo anterior
                    playerLeftContainer.appendChild(video);
                    // Inicialize o player Plyr para o novo vídeo
                    new Plyr(video);
                }
            }

            function loadPlayer(link, host) {
        // Verifica se o host é igual a 1 (iframe)
        if (host === '1') {
            const iframe = document.createElement('iframe');
            iframe.setAttribute('src', link);
            iframe.setAttribute('allowfullscreen', '');
            playerLeftContainer.innerHTML = ''; // Limpa o conteúdo anterior
            playerLeftContainer.appendChild(iframe);
        } else {
            // Caso contrário, use o player Plyr para carregar o vídeo
            const video = document.createElement('video');
            const source = document.createElement('source');
            video.appendChild(source);
            source.setAttribute('src', link);
            source.setAttribute('type', 'video/mp4');
            playerLeftContainer.innerHTML = ''; // Limpa o conteúdo anterior
            playerLeftContainer.appendChild(video);
            // Inicialize o player Plyr para o novo vídeo
            new Plyr(video);
        }
    }

            // Carregue o primeiro vídeo automaticamente
            const firstOption = playerOptions[0];
            loadPlayer(firstOption.getAttribute('data-link'), firstOption.getAttribute('data-host'));

            // Adicione os eventos de clique para carregar os vídeos selecionados
            playerOptions.forEach(option => {
                option.addEventListener('click', function () {
                    const link = this.getAttribute('data-link');
                    const host = this.getAttribute('data-host');
                    loadPlayer(link, host);
                });
            });
        });
    </script>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            $('#btnPesquisar').on('click', function () {
                let termo = $('#termo').val();
                $.ajax({
                    url: '/public/search/' + termo,
                    method: 'GET',
                    success: function (data) {
                        exibirResultados(data.search);
                    },
                    error: function (error) {
                        console.log(error);
                    }
                });
            });

            function exibirResultados(resultados) {
                let html = '';
                resultados.forEach(function (resultado) {
                    html += '<div>';
                    html += '<a href="/public/filme/' + resultado.id + '">';
                    // Verificando se o resultado possui poster_path antes de exibi-lo
                    if (resultado.poster_path) {
                        html += '<img src="' + resultado.poster_path + '" alt="' + resultado.name + '" style="max-width: 150px;">';
                    } else {
                        html += '<span>Imagem não disponível</span>';
                    }
                    html += '<br>';
                    html += resultado.name + ' - ' + resultado.type;
                    html += '</a>';
                    html += '</div>';
                });
                $('#resultados').html(html);
            }
        });
    </script>

<script>
    function abrirPlayer(link) {
      const player = document.getElementById('player');
      player.innerHTML = `<video width="400" controls><source src="${link}" type="video/mp4">Seu navegador não suporta o elemento de vídeo.</video>`;
    }
  </script>
    

    <!-- Adicione o link do JavaScript do plyr -->
    <script src="https://cdn.plyr.io/3.7.8/plyr.js"></script>
    <!-- Inclua a biblioteca js-cookie -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/js-cookie/3.0.1/js.cookie.min.js"></script>

    <script>
    document.addEventListener('DOMContentLoaded', () => {
    const player = new Plyr('video', {
        // Opções do Plyr
        controls: [
          'play-large', // The large play button in the center
          'restart', // Restart playback
          'rewind', // Rewind by the seek time (default 10 seconds)
          'play', // Play/pause playback
          'fast-forward', // Fast forward by the seek time (default 10 seconds)
          'progress', // The progress bar and scrubber for playback and buffering
          'current-time', // The current time of playback
          'duration', // The full duration of the media
          'mute', // Toggle mute
          'volume', // Volume control
          'captions', // Toggle captions
          'settings', // Settings menu
          'pip', // Picture-in-picture (currently Safari only)
          'fullscreen', // Toggle fullscreen
        ]
    });

    
    
    
    const saveVideoTimeToLocalStorage = (videoId, currentPosition) => {
        const videoData = {
            currentTime: currentPosition
        };
        localStorage.setItem(`videoData_${videoId}`, JSON.stringify(videoData));
    };

    // Função para obter a posição do vídeo do armazenamento local do navegador
    const getVideoTimeFromLocalStorage = (videoId) => {
        const videoData = localStorage.getItem(`videoData_${videoId}`);
        if (videoData) {
            const parsedData = JSON.parse(videoData);
            return parsedData.currentTime;
        }
        return null;
    };

    document.addEventListener('selectstart', function(event) {
      event.preventDefault();
    });

    // Recupere o ID do vídeo (substitua 'video_id_ficticio' pelo ID real do vídeo, se disponível)
    const videoId = '{{ $filme->videos->first()->id }}';

    // Recupere a posição do vídeo do armazenamento local e configure para continuar de onde parou
    const storedTime = getVideoTimeFromLocalStorage(videoId);
    if (storedTime) {
        player.on('loadedmetadata', () => {
            player.currentTime = parseFloat(storedTime); // Converter para número float
        });
    }

    // Adicione o ouvinte para o evento "timeupdate" do player Plyr
    player.on('timeupdate', () => {
        const currentPosition = player.currentTime;
        saveVideoTimeToLocalStorage(videoId, currentPosition);
    });
});
    </script>

<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        var mySwiper = new Swiper('.swiper-container', {
            
            freeMode: true,
            breakpoints: {
                // when window width is >= 320px
                320: {
                slidesPerView: 3,
                spaceBetween: 30
                },
                // when window width is >= 480px
                480: {
                slidesPerView: 3,
                spaceBetween: 30
                },

                800: {
                slidesPerView: 4,
                spaceBetween: 30
                },

                980: {
                slidesPerView: 5,
                spaceBetween: 30
                },

                1200: {
                slidesPerView: 6,
                spaceBetween: 30
                },

                1300: {
                slidesPerView: 7,
                spaceBetween: 30
                },
                // when window width is >= 640px
                1700: {
                slidesPerView: 10,
                spaceBetween: 40
                }
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            
        });
    });
</script>

</body>

</html>
