<!DOCTYPE html>
<html>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<head>
    <title>{{$serie->name}}</title>
    <link rel="stylesheet" href="https://cdn.plyr.io/3.7.8/plyr.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="/public/css/web.css">
    <link rel="icon" href="https://ultraflix.net/wp-content/uploads/2023/02/cropped-favicon-32x32.png" type="image/x-icon">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" />

</head>

@php
use Carbon\Carbon;
@endphp

<body>

    @include('layouts._partials.header')
    <section class="backdrop" style="background-image: linear-gradient(to right, rgb(0 0 0 / 80%), transparent), linear-gradient(to bottom, rgb(0 0 0 / 90%), transparent),linear-gradient(to top, rgb(0 0 0), transparent),
                  url('{{$serie->backdrop_path_tv}}');
    background-size: cover;
    background-position: center center;">

        <div class="main">

            <div class="poster-m">
                <aside>
                    <img src="{{ $serie->poster_path }}" alt="{{ $serie->name }}">
                </aside>

                <div>
                    <div class="titulo">
                        <h1>{{ $serie->name }}</h1>
                    </div>

                    <div class="genres">
                        <div class="imdb">
                            <p>
                                <i class="fas fa-star"></i> {{ number_format($serie->vote_average, 1) }}
                            </p>
                        </div>
                        <ul>
                            @foreach ($serie->genres->take(3) as $genre)
                            <li><strong>{{ $genre->name }}</strong></li>
                            @endforeach
                        </ul>

                    </div>

                    <div class="sinopse">
                        <p>{{ $serie->overview }}</p>
                    </div>

                    <div class="informacoes">
                        <li>Ano: <strong>{{ Carbon::createFromFormat('Y-m-d', $serie->first_air_date)->format('Y') }}</strong></li>
                    </div>

                    <div class="episodes">
                        <li>Episódios: <strong>{{ $serie->seasons->flatMap->episodes->count() }}</strong></li>

                    </div>

                    <div id="data-cast">
                        <span>Elenco:</span>
                        <ul>
                            @foreach ($serie->casters->take(3) as $index => $caster)
                            <li><strong>{{ $caster->name }}</strong>@if ($index < 2) , @endif</li>
                                    @endforeach
                        </ul>
                    </div>
                </div>
            </div>

            <body>
                <div class="containers">
                <select id="seasonSelector" onchange="showSeason()" onload="showSeason()">
                        @foreach ($serie->seasons as $season)
                        <option class="temps" value="{{ $season->season_number }}" @if ($loop->first) selected @endif>{{ $season->name }}</option>
                        @endforeach
                    </select>

                    <!-- Display the episodes of each season -->
                    <!-- Dentro do loop para os episódios -->

                    @foreach ($serie->seasons as $season)
                    <div class="ep {{ $season->season_number != 1 ? 'hidden' : '' }}" id="season_{{ $season->season_number }}">
                        <ul>
                            @foreach ($season->episodes as $episode)
                            <li id="season_{{ $season->season_number }}" class="episodio">
                                @if ($episode->videos[0]->link)
                                <img src="{{ $episode->still_path ?: asset('/public/episode') }}" onclick="openVideoModal('{{ $episode->videos[0]->link }}', {{ $episode->videos[0]->supported_hosts }})" alt="{{ $episode->name }} Still">
                                <div class="names">
                                    <div class="n-e-number">
                                        <h4>{{ $episode->episode_number }} - {{ $episode->name }}</h4>
                                    </div>
                                    <p>{{ $episode->overview }}</p>
                                </div>
                                @if (count($episode->videos) > 1)
                                <div id="videoOptions" style="display: none;">
                                    <button class="btn btn-primary" onclick="openVideoModal('{{ $episode->videos[1]->link }}')">Opção 2</button>
                                </div>
                                @endif
                                @else
                                <div class="unavailable-banner">
                                    O episódio não está disponível no momento.
                                </div>
                                @endif
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    @endforeach

                </div>

                <section class="related-series-slider">
                    <div class="prev-next">
                        <h2>Séries Relacionadas</h2>
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    </div>
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        @foreach ($seriesRelacionadas as $relatedSerie)
                            <div class="swiper-slide">
                                <a href="{{ route('serie.detail', ['id' => $relatedSerie->id]) }}">
                                    <img src="{{ $relatedSerie->poster_path }}" alt="{{ $relatedSerie->name }}">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
        </div>
    </section>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/slick-carousel@1.9.0/slick/slick.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

    <!-- Plyr JS -->
    <script src="https://cdn.plyr.io/3.7.8/plyr.js"></script>

    <script>
        let plyrPlayer;

        function openVideoModal(videoLink, supportedHosts) {
            const modalContent = document.createElement('div');

            if (supportedHosts === 1) {
                // For supported hosts, create an iframe
                modalContent.innerHTML = `<iframe src="${videoLink}" frameborder="0" allowfullscreen></iframe>`;
            } else {
                // For other hosts, create a video player using Plyr
                const videoPlayer = document.createElement('video');
                videoPlayer.controls = true;
                videoPlayer.src = videoLink;
                modalContent.appendChild(videoPlayer);
                plyrPlayer = new Plyr(videoPlayer);
            }

            $.fancybox.open({
                src: modalContent,
                type: 'html',
                touch: false, // Disable touch interactions for Plyr player (if used)
            });
        }

        function closeVideoModal() {
            if (plyrPlayer) {
                plyrPlayer.destroy();
                plyrPlayer = null;
            }
            $.fancybox.close();
        }

        function closeVideoModal() {
            document.getElementById('videoModal').classList.remove('show');
            document.getElementById('close-btn').style.display = 'none';
            document.getElementById('videoModal').style.display = 'none';
            document.querySelector('body').classList.remove('modal-open'); // Remove the 'modal-open' class from the body
            document.getElementById('overlay').classList.remove('show'); // Hide the backdrop overlay
            destroyPlyrPlayer();
        }

        function initPlyrPlayer(videoLink) {
            return new Promise((resolve, reject) => {
                const videoPlayerContainer = document.getElementById('plyr-container');
                videoPlayerContainer.innerHTML = ''; // Clear previous player if exists
                const videoPlayer = document.createElement('video');
                videoPlayer.controls = true;
                videoPlayer.src = videoLink;
                videoPlayerContainer.appendChild(videoPlayer);
                plyrPlayer = new Plyr(videoPlayer);

                plyrPlayer.on('ready', () => {
                    resolve();
                });
            });
        }

        function createPlyrPlayer(videoLink) {
            const videoPlayerContainer = document.getElementById('plyr-container');
            videoPlayerContainer.innerHTML = ''; // Clear previous player if exists
            const videoPlayer = document.createElement('video');
            videoPlayer.controls = true;
            videoPlayer.src = videoLink;
            videoPlayerContainer.appendChild(videoPlayer);
            plyrPlayer = new Plyr(videoPlayer);
        }

        function createIframePlayer(videoLink) {
            const iframeContainer = document.getElementById('plyr-container');
            iframeContainer.innerHTML = ''; // Clear previous content if exists
            const iframe = document.createElement('iframe');
            iframe.src = videoLink;
            iframe.allowfullscreen = true;
            iframeContainer.appendChild(iframe);
        }

        function destroyPlyrPlayer() {
            if (plyrPlayer) {
                plyrPlayer.destroy();
                plyrPlayer = null;
            }
        }

        function showSeason() {
        const selectedSeason = document.getElementById('seasonSelector').value;
        const seasons = document.querySelectorAll('[id^="season_"]');
        seasons.forEach((season) => {
            if (season.id === `season_${selectedSeason}`) {
                season.classList.remove('hidden');
            } else {
                season.classList.add('hidden');
            }
        });
    }
    </script>

    <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>



    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var mySwiper = new Swiper('.swiper-container', {
                slidesPerView: 5,
                spaceBetween: 30,
                direction: 'horizontal',
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },

            });
        });
    </script>



    <div class="modal-backdrop" id="overlay"></div>
    <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button aria-hidden="true" type="button" id="close-btn" style="display:none" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="modal-body">
                    <!-- Video player will be added here -->
                </div>
            </div>
        </div>
    </div>
    </div>
</body>

</html>